/**
 * This class stores informations for {@link DataProtectGeneration} retention
 * and automatic deletion.
 */
export type RetentionPolicy = {
    /**
     * Returns how many daily backup we should keep
     * 
     * <p>
     * null when we don't apply a daily retention policy
     * </p>
     */
    daily?: number;
    /**
     * Returns how many weekly backup we should keep
     * 
     * <p>
     * null when we don't apply a weekly retention policy
     * </p>
     */
    weekly?: number;
    /**
     * Returns how many monthly backup we should keep
     * 
     * <p>
     * null when we don't apply a monthly retention policy
     * </p>
     */
    monthly?: number;
};
