
import { PartGeneration } from "./PartGeneration"; 
import { 
    VersionInfo
} from "@bluemind/core.foldershare.api";
/**
 * This class represents a generation of protected Blue Mind data.
 * 
 * A {@link DataProtectGeneration} records when your data was protected, the
 * Blue Mind version and all the {@link ProtectedPart}s of the Blue Mind
 * infrastructure at this point in time.
 */
export type DataProtectGeneration = {
    id?: number;
    protectionTime?: number;
    blueMind?: VersionInfo;
    withWarnings?: boolean;
    withErrors?: boolean;
    parts?: Array<PartGeneration>;
};
