
import { ContainerSubscriptionModel } from "./ContainerSubscriptionModel"; 
import { ItemIdentifier } from "./ItemIdentifier"; 
import { ContainerChangeset } from "./ContainerChangeset"; 
import { ItemFlagFilter } from "./ItemFlagFilter"; 
import { ItemValue } from "./ItemValue"; 
import { ItemVersion } from "./ItemVersion"; 
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
export interface IOwnerSubscriptions {
    /**
     * @returns if successful, return a {@link ContainerChangeset}
     */
    changeset(since?: number,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<string>>;
    /**
     * @returns if successful, return a {@link ContainerChangeset} with internal
     *         numeric ids
     */
    changesetById(since?: number,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<number>>;
    /**
     * @param filter to exclude some items (eg. deleted items)
     * @returns if successful, return a {@link ContainerChangeset} with internal
     *         numeric ids matching the given filter
     */
    filteredChangesetById(since?: number, filter?: ItemFlagFilter,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<ItemVersion>>;
    /**
     * @returns if successful, return a {@link ContainerChangeset} with
     *         {@link ItemIdentifier}
     */
    fullChangesetById(since?: number,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<ItemIdentifier>>;
    getComplete(uid: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<ContainerSubscriptionModel>>;
    getCompleteById(id: number,  __fetchOptions?: RequestOptions): Promise<ItemValue<ContainerSubscriptionModel>>;
    getMultiple(uids?: Array<string>,  __fetchOptions?: RequestOptions): Promise<Array<ItemValue<ContainerSubscriptionModel>>>;
    getVersion( __fetchOptions?: RequestOptions): Promise<number>;
    list( __fetchOptions?: RequestOptions): Promise<Array<ItemValue<ContainerSubscriptionModel>>>;
    multipleGetById(ids?: Array<number>,  __fetchOptions?: RequestOptions): Promise<Array<ItemValue<ContainerSubscriptionModel>>>;
}

export declare class OwnerSubscriptionsClient extends ApiEndPoint implements IOwnerSubscriptions {
    domainUid: string;
    ownerUid: string;
    constructor(apiKey: string, domainUid: string, ownerUid: string, base?: string);
    changeset(since?: number,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<string>>;
    changesetById(since?: number,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<number>>;
    filteredChangesetById(since?: number, filter?: ItemFlagFilter,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<ItemVersion>>;
    fullChangesetById(since?: number,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<ItemIdentifier>>;
    getComplete(uid: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<ContainerSubscriptionModel>>;
    getCompleteById(id: number,  __fetchOptions?: RequestOptions): Promise<ItemValue<ContainerSubscriptionModel>>;
    getMultiple(uids?: Array<string>,  __fetchOptions?: RequestOptions): Promise<Array<ItemValue<ContainerSubscriptionModel>>>;
    getVersion( __fetchOptions?: RequestOptions): Promise<number>;
    list( __fetchOptions?: RequestOptions): Promise<Array<ItemValue<ContainerSubscriptionModel>>>;
    multipleGetById(ids?: Array<number>,  __fetchOptions?: RequestOptions): Promise<Array<ItemValue<ContainerSubscriptionModel>>>;
    getMetadata(): EndPointMetadata;
}
