import { 
    ContainerChangeset,
    ItemFlagFilter,
    ItemValue,
    ItemVersion
} from "@bluemind/core.container.api";

import { CalendarViewChanges } from "./CalendarViewChanges"; 
import { CalendarView } from "./CalendarView"; 
import { 
    ListResult
} from "@bluemind/core.foldershare.api";
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
export interface IUserCalendarViews {
    changeset(since?: number,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<string>>;
    changesetById(since?: number,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<number>>;
    /**
     * Creates a {@link CalendarView}
     */
    create(uid: string, view?: CalendarView,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Deletes a {@link CalendarView}
     */
    delete(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    filteredChangesetById(since?: number, arg1?: ItemFlagFilter,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<ItemVersion>>;
    /**
     * Retrieves a {@link CalendarView}
     */
    getComplete(uid: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<CalendarView>>;
    getCompleteById(id: number,  __fetchOptions?: RequestOptions): Promise<ItemValue<CalendarView>>;
    getVersion( __fetchOptions?: RequestOptions): Promise<number>;
    /**
     * Returns a list of {@link CalendarView}
     */
    list( __fetchOptions?: RequestOptions): Promise<ListResult<ItemValue<CalendarView>>>;
    /**
     * Fetch multiple {@link CalendarView}s from theirs uniques uids
     * @returns {@link List<ItemValue<CalendarView>>}
     */
    multipleGet(uids?: Array<string>,  __fetchOptions?: RequestOptions): Promise<Array<ItemValue<CalendarView>>>;
    multipleGetById(arg0?: Array<number>,  __fetchOptions?: RequestOptions): Promise<Array<ItemValue<CalendarView>>>;
    /**
     * Set user the default view. The default view is used when there is no data to
     * rely on to initialize calendar display.
     */
    setDefault(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Updates a {@link CalendarView}
     */
    update(uid: string, view?: CalendarView,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Applies changes (create, update, delete) to a calendar specified by its
     * <code>containerUid</code>.
     */
    updates(changes?: CalendarViewChanges,  __fetchOptions?: RequestOptions): Promise<void>;
}

export declare class UserCalendarViewsClient extends ApiEndPoint implements IUserCalendarViews {
    domainUid: string;
    userUid: string;
    constructor(apiKey: string, domainUid: string, userUid: string, base?: string);
    changeset(since?: number,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<string>>;
    changesetById(since?: number,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<number>>;
    create(uid: string, view?: CalendarView,  __fetchOptions?: RequestOptions): Promise<void>;
    delete(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    filteredChangesetById(since?: number, arg1?: ItemFlagFilter,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<ItemVersion>>;
    getComplete(uid: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<CalendarView>>;
    getCompleteById(id: number,  __fetchOptions?: RequestOptions): Promise<ItemValue<CalendarView>>;
    getVersion( __fetchOptions?: RequestOptions): Promise<number>;
    list( __fetchOptions?: RequestOptions): Promise<ListResult<ItemValue<CalendarView>>>;
    multipleGet(uids?: Array<string>,  __fetchOptions?: RequestOptions): Promise<Array<ItemValue<CalendarView>>>;
    multipleGetById(arg0?: Array<number>,  __fetchOptions?: RequestOptions): Promise<Array<ItemValue<CalendarView>>>;
    setDefault(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    update(uid: string, view?: CalendarView,  __fetchOptions?: RequestOptions): Promise<void>;
    updates(changes?: CalendarViewChanges,  __fetchOptions?: RequestOptions): Promise<void>;
    getMetadata(): EndPointMetadata;
}
