
import { PublishMode } from "./PublishMode"; 
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
export interface IPublishCalendar {
    /**
     * Create an url for external calendar access
     * @param mode publish mode, private or public
     * @param token associate this url with a token
     * @returns generated url
     */
    createUrl(mode: PublishMode, token?: string,  __fetchOptions?: RequestOptions): Promise<string>;
    disableUrl(url?: string,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Generate an url for external calendar access
     * @param mode publish mode, private or public
     * @returns generated url
     */
    generateUrl(mode: PublishMode,  __fetchOptions?: RequestOptions): Promise<string>;
    getGeneratedUrls(mode: PublishMode,  __fetchOptions?: RequestOptions): Promise<Array<string>>;
    publish(token: string,  __fetchOptions?: RequestOptions): Promise<Blob>;
}

export declare class PublishCalendarClient extends ApiEndPoint implements IPublishCalendar {
    containerUid: string;
    constructor(apiKey: string, containerUid: string, base?: string);
    createUrl(mode: PublishMode, token?: string,  __fetchOptions?: RequestOptions): Promise<string>;
    disableUrl(url?: string,  __fetchOptions?: RequestOptions): Promise<void>;
    generateUrl(mode: PublishMode,  __fetchOptions?: RequestOptions): Promise<string>;
    getGeneratedUrls(mode: PublishMode,  __fetchOptions?: RequestOptions): Promise<Array<string>>;
    publish(token: string,  __fetchOptions?: RequestOptions): Promise<Blob>;
    getMetadata(): EndPointMetadata;
}
