
import { CalendarSettingsData } from "./CalendarSettingsData"; 
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
export interface ICalendarSettings {
    /**
     * Retrieve calendar settings
     * @returns settings
     */
    get( __fetchOptions?: RequestOptions): Promise<CalendarSettingsData>;
    /**
     * Update calendar settings
     * @param settings calendar settings
     */
    set(settings?: CalendarSettingsData,  __fetchOptions?: RequestOptions): Promise<void>;
}

export declare class CalendarSettingsClient extends ApiEndPoint implements ICalendarSettings {
    calendarUid: string;
    constructor(apiKey: string, calendarUid: string, base?: string);
    get( __fetchOptions?: RequestOptions): Promise<CalendarSettingsData>;
    set(settings?: CalendarSettingsData,  __fetchOptions?: RequestOptions): Promise<void>;
    getMetadata(): EndPointMetadata;
}
