import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './UserInboxClient.json';

export class UserInboxClient extends ApiEndPoint {
    version = "5.4.2696";
    constructor(apiKey, domainUid , userUid , base = '') {
        super(apiKey, base + '/api/inbox/{domainUid}/{userUid}');
        this.domainUid = domainUid;
        this.base = this.base.replace('{domainUid}', encodeURIComponent(domainUid));
        this.userUid = userUid;
        this.base = this.base.replace('{userUid}', encodeURIComponent(userUid));
    }
    async unseen( __fetchOptions = {}) {
        let __path = this.base + '/_unseen';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
