import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './MailConversationClient.json';

export class MailConversationClient extends ApiEndPoint {
    version = "5.4.2696";
    constructor(apiKey, subtreeContainer , base = '') {
        super(apiKey, base + '/api/mail_conversation/{subtreeContainer}');
        this.subtreeContainer = subtreeContainer;
        this.base = this.base.replace('{subtreeContainer}', encodeURIComponent(subtreeContainer));
    }
    async byFolder(folder, sorted,  __fetchOptions = {}) {
        const __url = new URL(this.base, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (folder != null) {
            __url.searchParams.append("folder", folder);
        }
        if (sorted != null) {
            __options.body = JSON.stringify(sorted);
        }
		return this.__fetchContent(__url, __options);
    }
    async get(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async multipleGet(uids,  __fetchOptions = {}) {
        let __path = this.base + '/_mget';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (uids != null) {
            __options.body = JSON.stringify(uids);
        }
		return this.__fetchContent(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
