
/**
 * Conversation of messages.
 */
export type Conversation = {
    /**
     * The messages of this conversation. Implementations should ensure there are no
     * duplicates.
     */
    messageRefs?: Array<Conversation.MessageRef>;
    conversationId?: number;
    conversationUid?: string;
};
export namespace Conversation {
    export type MessageRef = {
        /**
         * The message 's folder unique identifier.
         */
        folderUid?: string;
        /**
         * The unique identifier of the message's item.
         */
        itemId?: number;
        /**
         * The creation date of the message's item.
         */
        date?: number;
    };

}
