import { ProgressMonitor } from "./ProgressMonitor";

export abstract class ApiEndPoint {
    /**
     * Client version
     */
    version: string;
    /**
     * Current session api key
     */
    apiKey: string;
    /**
     * BlueMind server base url
     */
    base: string;
    constructor(apiKey: string, base: string);
    /**
     * Get API endpoint interface description like endpoint path, methods name
     * and parameters, internal types, and annotations (deprecated, beta...).
     */
    abstract getMetadata(): EndPointMetadata;
    protected __fetchContent(url: URL, options: RequestOptions): Promise<any>;
    protected __fetchBlob(url: URL, options: RequestOptions): Promise<Blob>;
    protected __fetchVoid(url: URL, options: RequestOptions): Promise<void>;
    protected __getRequestInit(method: string, mime: string, options?: RequestOptions): RequestOptions;
    private __execute<T>(url: URL, options: RequestOptions, getContentCallback: (Response) => Promise<T>): Promise<T>;
    private __fetch(url: URL, options: RequestOptions): Promise<Response>;
}

/**
 *
 */
export type RequestOptions = RequestInit & {
    /** A EventTarget which will dispatch ProgressEvent to monitor the state of the Request @see {@link ProgressEvent}*/
    monitor?: ProgressMonitor;
};

export type EndPointMetadata = {
    className: string;
    packageName: string;
    path: EndPointMetadata.Path;
    methods: Array<EndPointMetadata.MethodMetadata>;
};
export declare namespace EndPointMetadata {
    export type Path = {
        value: string;
        parameters: Array<string>;
    };

    export type MethodMetadata = {
        name: string;
        verb: HTTPMethod;
        path: Path;
        inParams?: Array<ParameterMetadata>;
        outParam: ParameterType;
        produce: string | undefined;
    };

    export type ParameterMetadata = {
        name: string;
        type: ParameterType;
        paramType: "PathParam" | "Body" | "QueryParam";
    };

    export type ParameterType = {
        name: string;
    };

    export type HTTPMethod = "DELETE" | "GET" | "HEAD" | "PATCH" | "POST" | "PUT";
}
