
export type CertInfo = {
    usage?: Array<CertInfo.CertUsage>;
    x509Certificate?: ArrayBuffer;
};
export namespace CertInfo {
    export type CertUsage =  "digitalSignature" |  "nonRepudiation" |  "keyEncipherment" |  "dataEncipherment" |  "keyAgreement" |  "keyCertSign" |  "cRLSign" |  "encipherOnly" |  "decipherOnly";
    export const CertUsage : {
        readonly digitalSignature: CertUsage,
        readonly nonRepudiation: CertUsage,
        readonly keyEncipherment: CertUsage,
        readonly dataEncipherment: CertUsage,
        readonly keyAgreement: CertUsage,
        readonly keyCertSign: CertUsage,
        readonly cRLSign: CertUsage,
        readonly encipherOnly: CertUsage,
        readonly decipherOnly: CertUsage
    };

}
