/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2017
 *
 * This file is part of Blue Mind. Blue Mind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License)
 * or the CeCILL as published by CeCILL.info (version 2 of the License).
 *
 * There are special exceptions to the terms and conditions of the
 * licenses as they are applied to this program. See LICENSE.txt in
 * the directory of this program distribution.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.backend.mail.replica.service;

import net.bluemind.backend.mail.replica.api.IDbMailboxRecords;
import net.bluemind.backend.mail.replica.api.IDbMessageBodies;
import net.bluemind.backend.mail.replica.api.MailboxRecord;
import net.bluemind.backend.mail.replica.indexing.IMailIndexService;
import net.bluemind.backend.mail.replica.service.internal.DbMailboxRecordsService;
import net.bluemind.backend.mail.repository.IMailboxRecordStore;
import net.bluemind.core.api.fault.ServerFault;
import net.bluemind.core.container.model.Container;
import net.bluemind.core.container.model.acl.Verb;
import net.bluemind.core.container.service.internal.ContainerStoreService;
import net.bluemind.core.container.service.internal.RBACManager;
import net.bluemind.core.rest.BmContext;
import net.bluemind.mailbox.api.IMailboxAclUids;

public class DbMailboxRecordsServiceFactory extends AbstractMailboxRecordServiceFactory<IDbMailboxRecords> {

	public DbMailboxRecordsServiceFactory() {
		// ok
	}

	@Override
	public Class<IDbMailboxRecords> factoryClass() {
		return IDbMailboxRecords.class;
	}

	@Override
	protected IDbMailboxRecords create(Container cont, BmContext context, String mailboxUniqueId,
			IMailboxRecordStore recordStore, ContainerStoreService<MailboxRecord> storeService,
			IMailIndexService indexService, IDbMessageBodies bodiesApi) {
		RBACManager rbac = RBACManager.forContext(context).forContainer(IMailboxAclUids.uidForMailbox(cont.owner));
		try {
			rbac.check(Verb.Read.name());
		} catch (ServerFault e) {
			rbac = RBACManager.forContext(context).forContainer(cont.uid);
		}

		return new DbMailboxRecordsService(cont, context, mailboxUniqueId, recordStore, storeService, indexService,
				rbac, bodiesApi);
	}

}
