/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * RPC Client
 */
ResourcesClient._rpcClient;

/**
 * URL
 */
ResourcesClient._baseUrl;

/**
 * @type {string} domainUid
 * @private
 */
ResourcesClient.prototype._domainUid;

/**
 * @constructor
 */ 
function ResourcesClient(base, sid , domainUid ) {
  this._rpcClient = Components.classes["@blue-mind.net/rpcclient;1"].getService().wrappedJSObject;
  this._rpcClient.setAuthKey(sid ? sid : null);
  this._baseUrl = base + '/api/resources/{domainUid}';
  
  this._domainUid = domainUid;
  this._baseUrl = this._baseUrl.replace('{domainUid}',domainUid);
};

ResourcesClient.prototype.setAuthKey = function(sid) {
    this._rpcClient.setAuthKey(sid);
};

/*
 *
 */
ResourcesClient.prototype.addToEventDescription = function( uid ,  eventInfo  ) {
  let url = this._baseUrl + "/{uid}/addToEventDesc";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = eventInfo;
  return this._execute(cmd, body);
};

/*
 *
 */
ResourcesClient.prototype.byEmail = function( email  ) {
  let url = this._baseUrl + "/byEmail/{email}";

  url = url.replace("{email}", email);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
ResourcesClient.prototype.byType = function( type  ) {
  let url = this._baseUrl + "/byType/{type}";

  url = url.replace("{type}", type);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
ResourcesClient.prototype.create = function( uid ,  resourceDescriptor  ) {
  let url = this._baseUrl + "/{uid}";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "PUT", responseType);
  let body = null;
  body = resourceDescriptor;
  return this._execute(cmd, body);
};

/*
 *
 */
ResourcesClient.prototype.delete_ = function( uid  ) {
  let url = this._baseUrl + "/{uid}";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "DELETE", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
ResourcesClient.prototype.get = function( uid  ) {
  let url = this._baseUrl + "/{uid}";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
ResourcesClient.prototype.getIcon = function( uid  ) {
  let url = this._baseUrl + "/{uid}/icon";

  url = url.replace("{uid}", uid);

  let responseType = "";
  responseType = "arraybuffer";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
ResourcesClient.prototype.removeFromEventDescription = function( uid ,  eventInfo  ) {
  let url = this._baseUrl + "/{uid}/removeFromEventDesc";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = eventInfo;
  return this._execute(cmd, body);
};

/*
 *
 */
ResourcesClient.prototype.setIcon = function( uid ,  icon  ) {
  let url = this._baseUrl + "/{uid}/icon";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = icon;
  return this._execute(cmd, body);
};

/*
 *
 */
ResourcesClient.prototype.update = function( uid ,  resourceDescriptor  ) {
  let url = this._baseUrl + "/{uid}";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = resourceDescriptor;
  return this._execute(cmd, body);
};

ResourcesClient.prototype._execute = function(cmd, data) {
  cmd.getData = function() {
    if (data != null){
      return JSON.stringify(data);
    } 
    return null;
  };

  cmd.onSuccess = function(xhr) {
    let contentType = xhr.getResponseHeader("content-type");
    if (contentType == "application/json" && xhr.responseText) {
      cmd.resolve(JSON.parse(xhr.responseText));
    } else {
      cmd.resolve(xhr.response);
    }
  };

  cmd.onFailure = function(xhr) {
    let resp = xhr.response;
    if (resp != null) {
        cmd.reject(resp);
    } else {
        cmd.reject(xhr.status);
    }
  };

  let self = this;
  let result = new Promise(function(resolve, reject) {
    try {
      cmd.resolve = resolve;
      cmd.reject = reject;
      self._rpcClient.execute(cmd);
    } catch(e) {
      reject(e);
    }
  });
  return result;
}
