/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * RPC Client
 */
EasClient._rpcClient;

/**
 * URL
 */
EasClient._baseUrl;

/**
 * @constructor
 */ 
function EasClient(base, sid ) {
  this._rpcClient = Components.classes["@blue-mind.net/rpcclient;1"].getService().wrappedJSObject;
  this._rpcClient.setAuthKey(sid ? sid : null);
  this._baseUrl = base + '/api/eas';
  
};

EasClient.prototype.setAuthKey = function(sid) {
    this._rpcClient.setAuthKey(sid);
};

/*
 *
 */
EasClient.prototype.deletePendingReset = function( account  ) {
  let url = this._baseUrl + "/_deletePendingReset";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "DELETE", responseType);
  let body = null;
  body = account;
  return this._execute(cmd, body);
};

/*
 *
 */
EasClient.prototype.getConfiguration = function() {
  let url = this._baseUrl + "/_getConfiguration";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
EasClient.prototype.getFolderSyncVersions = function( account  ) {
  let url = this._baseUrl + "/_getFolderSync";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  body = account;
  return this._execute(cmd, body);
};

/*
 *
 */
EasClient.prototype.getHeartbeat = function( deviceUid  ) {
  let url = this._baseUrl + "/_heartbeat";


  url += "?deviceUid=" + encodeURIComponent(deviceUid);
  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
EasClient.prototype.insertClientId = function( clientId  ) {
  let url = this._baseUrl + "/_sendmailId/{clientId}";

  url = url.replace("{clientId}", clientId);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "PUT", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
EasClient.prototype.insertPendingReset = function( account  ) {
  let url = this._baseUrl + "/_reset";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "PUT", responseType);
  let body = null;
  body = account;
  return this._execute(cmd, body);
};

/*
 *
 */
EasClient.prototype.isKnownClientId = function( clientId  ) {
  let url = this._baseUrl + "/_sendmailId/{clientId}";

  url = url.replace("{clientId}", clientId);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
EasClient.prototype.needReset = function( account  ) {
  let url = this._baseUrl + "/_needReset";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  body = account;
  return this._execute(cmd, body);
};

/*
 *
 */
EasClient.prototype.setFolderSyncVersions = function( versions  ) {
  let url = this._baseUrl + "/_setFolderSync";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "PUT", responseType);
  let body = null;
  body = versions;
  return this._execute(cmd, body);
};

/*
 *
 */
EasClient.prototype.setHeartbeat = function( heartbeat  ) {
  let url = this._baseUrl + "/_heartbeat";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "PUT", responseType);
  let body = null;
  body = heartbeat;
  return this._execute(cmd, body);
};

EasClient.prototype._execute = function(cmd, data) {
  cmd.getData = function() {
    if (data != null){
      return JSON.stringify(data);
    } 
    return null;
  };

  cmd.onSuccess = function(xhr) {
    let contentType = xhr.getResponseHeader("content-type");
    if (contentType == "application/json" && xhr.responseText) {
      cmd.resolve(JSON.parse(xhr.responseText));
    } else {
      cmd.resolve(xhr.response);
    }
  };

  cmd.onFailure = function(xhr) {
    let resp = xhr.response;
    if (resp != null) {
        cmd.reject(resp);
    } else {
        cmd.reject(xhr.status);
    }
  };

  let self = this;
  let result = new Promise(function(resolve, reject) {
    try {
      cmd.resolve = resolve;
      cmd.reject = reject;
      self._rpcClient.execute(cmd);
    } catch(e) {
      reject(e);
    }
  });
  return result;
}
