/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * RPC Client
 */
DataProtectClient._rpcClient;

/**
 * URL
 */
DataProtectClient._baseUrl;

/**
 * @constructor
 */ 
function DataProtectClient(base, sid ) {
  this._rpcClient = Components.classes["@blue-mind.net/rpcclient;1"].getService().wrappedJSObject;
  this._rpcClient.setAuthKey(sid ? sid : null);
  this._baseUrl = base + '/api/dataprotect';
  
};

DataProtectClient.prototype.setAuthKey = function(sid) {
    this._rpcClient.setAuthKey(sid);
};

/*
 *
 */
DataProtectClient.prototype.forget = function( generationId  ) {
  let url = this._baseUrl + "/generations";


  url += "?generationId=" + encodeURIComponent(generationId);
  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "DELETE", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
DataProtectClient.prototype.getAvailableGenerations = function() {
  let url = this._baseUrl + "/generations";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
DataProtectClient.prototype.getContent = function( partGen  ) {
  let url = this._baseUrl + "/_content/{partGen}";

  url = url.replace("{partGen}", partGen);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
DataProtectClient.prototype.getRestoreCapabilities = function() {
  let url = this._baseUrl + "/restore/_capabilities";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
DataProtectClient.prototype.getRestoreCapabilitiesByTags = function( tags  ) {
  let url = this._baseUrl + "/restore/_capabilities_by_tags";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  body = tags;
  return this._execute(cmd, body);
};

/*
 *
 */
DataProtectClient.prototype.getRetentionPolicy = function() {
  let url = this._baseUrl + "/policy";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
DataProtectClient.prototype.run = function( restoreDefinition  ) {
  let url = this._baseUrl + "/restore";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = restoreDefinition;
  return this._execute(cmd, body);
};

/*
 *
 */
DataProtectClient.prototype.saveAll = function() {
  let url = this._baseUrl + "/_backup";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
DataProtectClient.prototype.syncWithFilesystem = function() {
  let url = this._baseUrl + "/_syncfs";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
DataProtectClient.prototype.updatePolicy = function( rp  ) {
  let url = this._baseUrl + "/policy";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = rp;
  return this._execute(cmd, body);
};

DataProtectClient.prototype._execute = function(cmd, data) {
  cmd.getData = function() {
    if (data != null){
      return JSON.stringify(data);
    } 
    return null;
  };

  cmd.onSuccess = function(xhr) {
    let contentType = xhr.getResponseHeader("content-type");
    if (contentType == "application/json" && xhr.responseText) {
      cmd.resolve(JSON.parse(xhr.responseText));
    } else {
      cmd.resolve(xhr.response);
    }
  };

  cmd.onFailure = function(xhr) {
    let resp = xhr.response;
    if (resp != null) {
        cmd.reject(resp);
    } else {
        cmd.reject(xhr.status);
    }
  };

  let self = this;
  let result = new Promise(function(resolve, reject) {
    try {
      cmd.resolve = resolve;
      cmd.reject = reject;
      self._rpcClient.execute(cmd);
    } catch(e) {
      reject(e);
    }
  });
  return result;
}
