/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * RPC Client
 */
CalendarViewClient._rpcClient;

/**
 * URL
 */
CalendarViewClient._baseUrl;

/**
 * @type {string} containerUid
 * @private
 */
CalendarViewClient.prototype._containerUid;

/**
 * @constructor
 */ 
function CalendarViewClient(base, sid , containerUid ) {
  this._rpcClient = Components.classes["@blue-mind.net/rpcclient;1"].getService().wrappedJSObject;
  this._rpcClient.setAuthKey(sid ? sid : null);
  this._baseUrl = base + '/api/calendars/view/{containerUid}';
  
  this._containerUid = containerUid;
  this._baseUrl = this._baseUrl.replace('{containerUid}',containerUid);
};

CalendarViewClient.prototype.setAuthKey = function(sid) {
    this._rpcClient.setAuthKey(sid);
};

/*
 *
 */
CalendarViewClient.prototype.create = function( uid ,  view  ) {
  let url = this._baseUrl + "/{uid}";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "PUT", responseType);
  let body = null;
  body = view;
  return this._execute(cmd, body);
};

/*
 *
 */
CalendarViewClient.prototype.delete_ = function( uid  ) {
  let url = this._baseUrl + "/{uid}";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "DELETE", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
CalendarViewClient.prototype.getComplete = function( uid  ) {
  let url = this._baseUrl + "/{uid}";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
CalendarViewClient.prototype.list = function() {
  let url = this._baseUrl + "/_list";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
CalendarViewClient.prototype.multipleGet = function( uids  ) {
  let url = this._baseUrl + "/_mget";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = uids;
  return this._execute(cmd, body);
};

/*
 *
 */
CalendarViewClient.prototype.setDefault = function( uid  ) {
  let url = this._baseUrl + "/{uid}/_asdefault";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
CalendarViewClient.prototype.update = function( uid ,  view  ) {
  let url = this._baseUrl + "/{uid}";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = view;
  return this._execute(cmd, body);
};

/*
 *
 */
CalendarViewClient.prototype.updates = function( changes  ) {
  let url = this._baseUrl + "/_mupdates";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "PUT", responseType);
  let body = null;
  body = changes;
  return this._execute(cmd, body);
};

CalendarViewClient.prototype._execute = function(cmd, data) {
  cmd.getData = function() {
    if (data != null){
      return JSON.stringify(data);
    } 
    return null;
  };

  cmd.onSuccess = function(xhr) {
    let contentType = xhr.getResponseHeader("content-type");
    if (contentType == "application/json" && xhr.responseText) {
      cmd.resolve(JSON.parse(xhr.responseText));
    } else {
      cmd.resolve(xhr.response);
    }
  };

  cmd.onFailure = function(xhr) {
    let resp = xhr.response;
    if (resp != null) {
        cmd.reject(resp);
    } else {
        cmd.reject(xhr.status);
    }
  };

  let self = this;
  let result = new Promise(function(resolve, reject) {
    try {
      cmd.resolve = resolve;
      cmd.reject = reject;
      self._rpcClient.execute(cmd);
    } catch(e) {
      reject(e);
    }
  });
  return result;
}
