/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * RPC Client
 */
AddressBooksMgmtClient._rpcClient;

/**
 * URL
 */
AddressBooksMgmtClient._baseUrl;

/**
 * @constructor
 */ 
function AddressBooksMgmtClient(base, sid ) {
  this._rpcClient = Components.classes["@blue-mind.net/rpcclient;1"].getService().wrappedJSObject;
  this._rpcClient.setAuthKey(sid ? sid : null);
  this._baseUrl = base + '/api/mgmt/addressbooks';
  
};

AddressBooksMgmtClient.prototype.setAuthKey = function(sid) {
    this._rpcClient.setAuthKey(sid);
};

/*
 *
 */
AddressBooksMgmtClient.prototype.backup = function( containerUid ,  since  ) {
  let url = this._baseUrl + "/{containerUid}/_backupstream";

  url = url.replace("{containerUid}", containerUid);

  url += "?since=" + encodeURIComponent(since);
  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
AddressBooksMgmtClient.prototype.create = function( containerUid ,  descriptor ,  isDefault  ) {
  let url = this._baseUrl + "/{containerUid}";

  url = url.replace("{containerUid}", containerUid);

  url += "?isDefault=" + encodeURIComponent(isDefault);
  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "PUT", responseType);
  let body = null;
  body = descriptor;
  return this._execute(cmd, body);
};

/*
 *
 */
AddressBooksMgmtClient.prototype.delete_ = function( containerUid  ) {
  let url = this._baseUrl + "/{containerUid}";

  url = url.replace("{containerUid}", containerUid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "DELETE", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
AddressBooksMgmtClient.prototype.getComplete = function( containerUid  ) {
  let url = this._baseUrl + "/{containerUid}";

  url = url.replace("{containerUid}", containerUid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
AddressBooksMgmtClient.prototype.reindex = function( containerUid  ) {
  let url = this._baseUrl + "/{containerUid}/_reindex";

  url = url.replace("{containerUid}", containerUid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
AddressBooksMgmtClient.prototype.reindexAll = function() {
  let url = this._baseUrl + "/_reindex";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
AddressBooksMgmtClient.prototype.reindexDomain = function( domain  ) {
  let url = this._baseUrl + "/_reindexDomain";


  url += "?domain=" + encodeURIComponent(domain);
  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
AddressBooksMgmtClient.prototype.restore = function( containerUid ,  restoreStream ,  reset  ) {
  let url = this._baseUrl + "/{containerUid}/_restorestream";

  url = url.replace("{containerUid}", containerUid);

  url += "?reset=" + encodeURIComponent(reset);
  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = restoreStream;
  return this._execute(cmd, body);
};

/*
 *
 */
AddressBooksMgmtClient.prototype.update = function( containerUid ,  descriptor  ) {
  let url = this._baseUrl + "/{containerUid}";

  url = url.replace("{containerUid}", containerUid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = descriptor;
  return this._execute(cmd, body);
};

AddressBooksMgmtClient.prototype._execute = function(cmd, data) {
  cmd.getData = function() {
    if (data != null){
      return JSON.stringify(data);
    } 
    return null;
  };

  cmd.onSuccess = function(xhr) {
    let contentType = xhr.getResponseHeader("content-type");
    if (contentType == "application/json" && xhr.responseText) {
      cmd.resolve(JSON.parse(xhr.responseText));
    } else {
      cmd.resolve(xhr.response);
    }
  };

  cmd.onFailure = function(xhr) {
    let resp = xhr.response;
    if (resp != null) {
        cmd.reject(resp);
    } else {
        cmd.reject(xhr.status);
    }
  };

  let self = this;
  let result = new Promise(function(resolve, reject) {
    try {
      cmd.resolve = resolve;
      cmd.reject = reject;
      self._rpcClient.execute(cmd);
    } catch(e) {
      reject(e);
    }
  });
  return result;
}
