/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.filehosting.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class FileHostingItemGwtSerDer implements GwtSerDer<net.bluemind.filehosting.api.FileHostingItem> {

	public FileHostingItemGwtSerDer( ) {
	}

	@Override
	public net.bluemind.filehosting.api.FileHostingItem deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.filehosting.api.FileHostingItem ret = new net.bluemind.filehosting.api.FileHostingItem();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.filehosting.api.FileHostingItem ret, JSONObject json) {
		JSONValue pathJSON = json.get("path");
		ret.path =  GwtSerDerUtils.STRING.deserialize(pathJSON);
		JSONValue nameJSON = json.get("name");
		ret.name =  GwtSerDerUtils.STRING.deserialize(nameJSON);
		JSONValue typeJSON = json.get("type");
		ret.type =  new net.bluemind.filehosting.api.gwt.serder.FileTypeGwtSerDer().deserialize(typeJSON);
		JSONValue sizeJSON = json.get("size");
		ret.size =  GwtSerDerUtils.LONG.deserialize(sizeJSON);
		JSONValue metadataJSON = json.get("metadata");
		ret.metadata =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.filehosting.api.gwt.serder.MetadataGwtSerDer()).deserialize(metadataJSON);
	}

	public void deserializeTo(net.bluemind.filehosting.api.FileHostingItem ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("path")) {
			JSONValue pathJSON = json.get("path");
			ret.path =  GwtSerDerUtils.STRING.deserialize(pathJSON);
		}
		if (!childPropertiesToIgnore.contains("name")) {
			JSONValue nameJSON = json.get("name");
			ret.name =  GwtSerDerUtils.STRING.deserialize(nameJSON);
		}
		if (!childPropertiesToIgnore.contains("type")) {
			JSONValue typeJSON = json.get("type");
			ret.type =  new net.bluemind.filehosting.api.gwt.serder.FileTypeGwtSerDer().deserialize(typeJSON);
		}
		if (!childPropertiesToIgnore.contains("size")) {
			JSONValue sizeJSON = json.get("size");
			ret.size =  GwtSerDerUtils.LONG.deserialize(sizeJSON);
		}
		if (!childPropertiesToIgnore.contains("metadata")) {
			JSONValue metadataJSON = json.get("metadata");
			ret.metadata =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.filehosting.api.gwt.serder.MetadataGwtSerDer()).deserialize(metadataJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.filehosting.api.FileHostingItem o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.filehosting.api.FileHostingItem o, JSONObject ret) {

		ret.put("path",  GwtSerDerUtils.STRING.serialize( o.path ));
		ret.put("name",  GwtSerDerUtils.STRING.serialize( o.name ));
		ret.put("type",  new net.bluemind.filehosting.api.gwt.serder.FileTypeGwtSerDer().serialize( o.type ));
		ret.put("size",  GwtSerDerUtils.LONG.serialize( o.size ));
		ret.put("metadata",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.filehosting.api.gwt.serder.MetadataGwtSerDer()).serialize( o.metadata ));
	}

	public void serializeTo(net.bluemind.filehosting.api.FileHostingItem o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("path")) {
			ret.put("path",  GwtSerDerUtils.STRING.serialize( o.path ));
		}
		if (!childPropertiesToIgnore.contains("name")) {
			ret.put("name",  GwtSerDerUtils.STRING.serialize( o.name ));
		}
		if (!childPropertiesToIgnore.contains("type")) {
			ret.put("type",  new net.bluemind.filehosting.api.gwt.serder.FileTypeGwtSerDer().serialize( o.type ));
		}
		if (!childPropertiesToIgnore.contains("size")) {
			ret.put("size",  GwtSerDerUtils.LONG.serialize( o.size ));
		}
		if (!childPropertiesToIgnore.contains("metadata")) {
			ret.put("metadata",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.filehosting.api.gwt.serder.MetadataGwtSerDer()).serialize( o.metadata ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}