package net.bluemind.central.reverse.proxy.model.common.mapper;

import java.util.Optional;

import net.bluemind.central.reverse.proxy.model.common.mapper.impl.ByteArrayRecordKeyMapper;
import net.bluemind.central.reverse.proxy.model.common.mapper.impl.Mapper;

public interface RecordKeyMapper<T> {

	public static record PartitionnedKey<T>(int part, T key) {

	}

	default Optional<RecordKey> map(PartitionnedKey<T> withPartition) {
		return map(withPartition.key());
	}

	Optional<RecordKey> map(T key);

	Optional<T> map(RecordKey key);

	static RecordKeyMapper<byte[]> byteArray() {
		return new ByteArrayRecordKeyMapper(Mapper.mapper);
	}
}
