/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.indexing.incremental.repository;

import java.sql.SQLException;
import java.time.Instant;
import java.util.List;
import java.util.Set;

import net.bluemind.core.container.model.ContainerUid;

public interface IIncrementalIndexingStore {

	public static final long DO_NOT_INDEX = -42L;

	public record ContainerSyncState(ContainerUid cont, long version) {

	}

	public record DirtynessMarker(ContainerUid container, Instant since) {

	}

	ContainerSyncState getState(ContainerUid cuid) throws SQLException;

	void markDirty(ContainerUid c) throws SQLException;

	/*
	 * returns true if the checkpoint / delete was sucessfull (it's the last state
	 * we have seen). Otherwise, you must re-index the newer version.
	 */
	boolean checkpointSync(ContainerSyncState stateUpdate, DirtynessMarker marker) throws SQLException;

	List<DirtynessMarker> fetchNexts(Set<String> inprogressids, int limit) throws SQLException;

	void forgetStates();

	long slowCostlyCount() throws SQLException;

}
