/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.metrics.alerts.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class CheckResultGwtSerDer implements GwtSerDer<net.bluemind.metrics.alerts.api.CheckResult> {

	public CheckResultGwtSerDer( ) {
	}

	@Override
	public net.bluemind.metrics.alerts.api.CheckResult deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.metrics.alerts.api.CheckResult ret = new net.bluemind.metrics.alerts.api.CheckResult();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.metrics.alerts.api.CheckResult ret, JSONObject json) {
		JSONValue levelJSON = json.get("level");
		ret.level =  new net.bluemind.metrics.alerts.api.gwt.serder.CheckResultLevelGwtSerDer().deserialize(levelJSON);
		JSONValue messageJSON = json.get("message");
		ret.message =  GwtSerDerUtils.STRING.deserialize(messageJSON);
	}

	public void deserializeTo(net.bluemind.metrics.alerts.api.CheckResult ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("level")) {
			JSONValue levelJSON = json.get("level");
			ret.level =  new net.bluemind.metrics.alerts.api.gwt.serder.CheckResultLevelGwtSerDer().deserialize(levelJSON);
		}
		if (!childPropertiesToIgnore.contains("message")) {
			JSONValue messageJSON = json.get("message");
			ret.message =  GwtSerDerUtils.STRING.deserialize(messageJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.metrics.alerts.api.CheckResult o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.metrics.alerts.api.CheckResult o, JSONObject ret) {

		ret.put("level",  new net.bluemind.metrics.alerts.api.gwt.serder.CheckResultLevelGwtSerDer().serialize( o.level ));
		ret.put("message",  GwtSerDerUtils.STRING.serialize( o.message ));
	}

	public void serializeTo(net.bluemind.metrics.alerts.api.CheckResult o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("level")) {
			ret.put("level",  new net.bluemind.metrics.alerts.api.gwt.serder.CheckResultLevelGwtSerDer().serialize( o.level ));
		}
		if (!childPropertiesToIgnore.contains("message")) {
			ret.put("message",  GwtSerDerUtils.STRING.serialize( o.message ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}