<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * ICalendarElementRRule.
 */
class ICalendarElementRRule  {

  /*
   * @type ICalendarElementRRuleFrequency
   */
  public $frequency;

  /*
   * @type Integer
   */
  public $count;

  /*
   * @type BmDateTime
   */
  public $until;

  /*
   * @type Integer
   */
  public $interval;

  /*
   * @type List
   */
  public $bySecond;

  /*
   * @type List
   */
  public $byMinute;

  /*
   * @type List
   */
  public $byHour;

  /*
   * @type List
   */
  public $byDay;

  /*
   * @type List
   */
  public $byMonthDay;

  /*
   * @type List
   */
  public $byYearDay;

  /*
   * @type List
   */
  public $byWeekNo;

  /*
   * @type List
   */
  public $byMonth;

  /*
   * @type List
   */
  public $bySetPos;

  /*
   * Constructor
   */
  public function __construct() {
    $this->count = null;
    $this->until = null;
    $this->interval = null;
    $this->bySecond =  array();
    $this->byMinute =  array();
    $this->byHour =  array();
    $this->byDay =  array();
    $this->byMonthDay =  array();
    $this->byYearDay =  array();
    $this->byWeekNo =  array();
    $this->byMonth =  array();
    $this->bySetPos =  array();
  }

  public function toMap() {
    $data = array(    
        "frequency" => empty($this->frequency) ? null : $this->frequency,    
        "count" => empty($this->count) ? null : $this->count,    
        "until" => empty($this->until) ? null : $this->until,    
        "interval" => empty($this->interval) ? null : $this->interval,    
        "bySecond" => empty($this->bySecond) ? null : $this->bySecond,    
        "byMinute" => empty($this->byMinute) ? null : $this->byMinute,    
        "byHour" => empty($this->byHour) ? null : $this->byHour,    
        "byDay" => empty($this->byDay) ? null : $this->byDay,    
        "byMonthDay" => empty($this->byMonthDay) ? null : $this->byMonthDay,    
        "byYearDay" => empty($this->byYearDay) ? null : $this->byYearDay,    
        "byWeekNo" => empty($this->byWeekNo) ? null : $this->byWeekNo,    
        "byMonth" => empty($this->byMonth) ? null : $this->byMonth,    
        "bySetPos" => empty($this->bySetPos) ? null : $this->bySetPos);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
