<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * ICalendarElementOrganizer.
 */
class ICalendarElementOrganizer  {

  /*
   * @type String
   */
  public $uri;

  /*
   * @type String
   */
  public $commonName;

  /*
   * @type String
   */
  public $mailto;

  /*
   * @type String
   */
  public $dir;

  /*
   * Constructor
   */
  public function __construct() {
    $this->uri = "";
    $this->commonName = "";
    $this->mailto = "";
    $this->dir = "";
  }

  public function toMap() {
    $data = array(    
        "uri" => empty($this->uri) ? null : $this->uri,    
        "commonName" => empty($this->commonName) ? null : $this->commonName,    
        "mailto" => empty($this->mailto) ? null : $this->mailto,    
        "dir" => empty($this->dir) ? null : $this->dir);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
