/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2024
  *
  * This file is part of Blue Mind. Blue Mind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License)
  * or the CeCILL as published by CeCILL.info (version 2 of the License).
  *
  * There are special exceptions to the terms and conditions of the
  * licenses as they are applied to this program. See LICENSE.txt in
  * the directory of this program distribution.
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.dataprotect.calendar.impl.pg;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import net.bluemind.calendar.api.CalendarDescriptor;
import net.bluemind.calendar.api.ICalendar;
import net.bluemind.calendar.api.ICalendarsMgmt;
import net.bluemind.core.container.model.ItemValue;
import net.bluemind.core.context.SecurityContext;
import net.bluemind.core.rest.BmContext;
import net.bluemind.core.rest.ServerSideServiceProvider;
import net.bluemind.dataprotect.api.DPError;
import net.bluemind.dataprotect.api.DataProtectGeneration;
import net.bluemind.dataprotect.calendar.impl.CommonRestoreCalendar;
import net.bluemind.dataprotect.calendar.impl.domain.RestoreDomainCalendarsWorker;
import net.bluemind.dataprotect.common.restore.IMonitoredRestoreRestorableItem;
import net.bluemind.dataprotect.service.BackupDataProvider;

public class RestoreDomainCalendarsTaskPg {

	private static final Logger logger = LoggerFactory.getLogger(RestoreDomainCalendarsTaskPg.class);
	private IMonitoredRestoreRestorableItem restorableItem;
	private DataProtectGeneration backup;
	private RestoreDomainCalendarsWorker domainCalendarsWorker;

	/**
	 * @deprecated REMOVE THIS IN BlueMind 6+
	 */
	@Deprecated
	public RestoreDomainCalendarsTaskPg(DataProtectGeneration backup, IMonitoredRestoreRestorableItem restorableItem,
			RestoreDomainCalendarsWorker domainCalendarsWorker) {
		this.backup = backup;
		this.restorableItem = restorableItem;
		this.domainCalendarsWorker = domainCalendarsWorker;
	}

	public void run() {
		try (BackupDataProvider bdp = new BackupDataProvider(null, SecurityContext.SYSTEM,
				restorableItem.getMonitor())) {
			BmContext back = bdp.createContextWithData(backup, restorableItem.item());
			BmContext live = ServerSideServiceProvider.getProvider(SecurityContext.SYSTEM).getContext();

			CalendarDescriptor backCalendarDescriptor = back.provider().instance(ICalendarsMgmt.class)
					.get(restorableItem.entryUid());

			List<String> allUids = back.provider().instance(ICalendar.class, restorableItem.entryUid()).all();
			restorableItem.monitorLog("Restoring '{}' events from {} [uid={}]", allUids.size(),
					backCalendarDescriptor.name, restorableItem.entryUid());

			domainCalendarsWorker
					.createOrUpdateLiveEntry(ItemValue.create(restorableItem.entryUid(), backCalendarDescriptor));

			new CommonRestoreCalendar(restorableItem, back, live).restoreEntities(allUids);

		} catch (Exception e) {
			logger.error("Error while restoring domain calendars {}@{}: {}", restorableItem.entryUid(),
					restorableItem.domain(), e.getMessage());
			restorableItem.errors()
					.add(DPError.restore(e.getMessage(), restorableItem.entryUid(), DPError.DPKind.DOMAIN_CALENDAR));
		} finally {
			restorableItem.endTask();
		}
	}
}
