import { h, render } from "vue";
import store from "@bluemind/store";
import { attachmentUtils, fileUtils, messageUtils, signatureUtils } from "@bluemind/mail";
import ComposerLinksWithFrame from "~/components/ComposerLinks/ComposerLinksWithFrame";

import { LINKS_CLASSNAME } from "./renderers";
import { getFhHeader, getFhInfos } from "./index";

const { CORPORATE_SIGNATURE_SELECTOR, PERSONAL_SIGNATURE_SELECTOR } = signatureUtils;
const { FileStatus } = fileUtils;
const { BmPreserveAttribute, MessageReplyAttributeSeparator, MessageForwardAttributeSeparator, computeParts } =
    messageUtils;
const { AttachmentAdaptor } = attachmentUtils;

export default function getContentWithLinks(message) {
    const container = document.createElement("template");
    container.innerHTML = store.state.mail.messageCompose.editorContent;
    const editorContent = container.content;

    const previousLinks = getPreviousNode(editorContent);
    previousLinks?.remove();

    const attachedFiles = getUploadedFiles(message);
    const linksVNode = h(ComposerLinksWithFrame, {
        files: attachedFiles
    });
    const linkContainer = document.createElement("div");
    linkContainer.setAttribute(BmPreserveAttribute, true);
    linkContainer.setAttribute("class", LINKS_CLASSNAME);
    render(linksVNode, linkContainer);

    const signatureElement = findSignatureElement(editorContent);
    signatureElement
        ? signatureElement.parentNode.insertBefore(linkContainer, signatureElement)
        : editorContent.appendChild(linkContainer);

    return container.innerHTML;
}

function findSignatureElement(fragment) {
    return (
        fragment.querySelector(CORPORATE_SIGNATURE_SELECTOR) ||
        fragment.querySelector(PERSONAL_SIGNATURE_SELECTOR(store.state.mail.messageCompose.personalSignature.id))
    );
}
function getUploadedFiles(message) {
    const parts = computeParts(message.structure);
    const files = AttachmentAdaptor.extractFiles(parts.attachments, message);

    return files.flatMap(file => {
        const isFh = !!getFhHeader(file.headers);
        if (isFh && file.status === FileStatus.UPLOADED) {
            return {
                ...file,
                ...getFhInfos(file)
            };
        }
        return [];
    });
}

function isCorrectNode(fragment, node) {
    const reply =
        fragment.querySelector(`.${MessageReplyAttributeSeparator}`) ||
        fragment.querySelector(`#${MessageReplyAttributeSeparator}`);
    const forward =
        fragment.querySelector(`.${MessageForwardAttributeSeparator}`) ||
        fragment.querySelector(`#${MessageForwardAttributeSeparator}`);
    return !((reply && reply.contains(node)) || (forward && forward.contains(node)));
}

function getPreviousNode(fragment) {
    const previousNodes = fragment.querySelectorAll(`.${LINKS_CLASSNAME}`);
    for (const node of previousNodes) {
        if (isCorrectNode(fragment, node)) {
            return node;
        }
    }
}
