/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.authentication.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONValue;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;

public class UserAccessTokenGwtEndpoint implements net.bluemind.authentication.api.IUserAccessTokenAsync {

	private String baseUri;

	private String sessionId;

	private String root = "/api";

	public UserAccessTokenGwtEndpoint(String sessionId, String... pathVars) {
		String uri_ = "/auth/access_token";
		this.sessionId = sessionId;
	

		baseUri = uri_;
	}

	public UserAccessTokenGwtEndpoint withRoot(String root) {
		this.root = root;
		return this;
	}

	@Override
	public void authCodeReceived(String state, String code, final AsyncHandler<net.bluemind.authentication.api.AccessTokenInfo> handler) {
		String postUri = "/_auth";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		queryParams += "&state=" + URL.encodeQueryString(""+state);
		queryParams += "&code=" + URL.encodeQueryString(""+code);
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.authentication.api.AccessTokenInfo>(handler) {
			@Override
			protected net.bluemind.authentication.api.AccessTokenInfo handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.authentication.api.gwt.serder.AccessTokenInfoGwtSerDer().deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void getTokenInfo(String external_system, String baseUrl, final AsyncHandler<net.bluemind.authentication.api.AccessTokenInfo> handler) {
		String postUri = "/_info";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		queryParams += "&external_system=" + URL.encodeQueryString(""+external_system);
		queryParams += "&baseUrl=" + URL.encodeQueryString(""+baseUrl);
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.authentication.api.AccessTokenInfo>(handler) {
			@Override
			protected net.bluemind.authentication.api.AccessTokenInfo handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.authentication.api.gwt.serder.AccessTokenInfoGwtSerDer().deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}

	public net.bluemind.authentication.api.IUserAccessTokenPromise promiseApi() {
		return new UserAccessTokenEndpointPromise(this);
	}
}
