<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * AddressBookDescriptor.
 */
class AddressBookDescriptor  {

  /*
   * @type String
   */
  public $name;

  /*
   * @type String
   */
  public $domainUid;

  /*
   * @type String
   */
  public $owner;

  /*
   * @type boolean
   */
  public $system;

  /*
   * @type Map
   */
  public $settings;

  /*
   * @type String
   */
  public $orgUnitUid;

  /*
   * @type Long
   */
  public $expectedId;

  /*
   * Constructor
   */
  public function __construct() {
    $this->name = "";
    $this->domainUid = "";
    $this->owner = "";
    $this->system = false;
    $this->settings = array();
    $this->orgUnitUid = "";
    $this->expectedId = null;
  }

  public function toMap() {
    $data = array(    
        "name" => empty($this->name) ? null : $this->name,    
        "domainUid" => empty($this->domainUid) ? null : $this->domainUid,    
        "owner" => empty($this->owner) ? null : $this->owner,    
        "system" => empty($this->system) ? null : $this->system,    
        "settings" => empty($this->settings) ? null : $this->settings,    
        "orgUnitUid" => empty($this->orgUnitUid) ? null : $this->orgUnitUid,    
        "expectedId" => empty($this->expectedId) ? null : $this->expectedId);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
