/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.addressbook.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class CertInfoGwtSerDer implements GwtSerDer<net.bluemind.addressbook.api.CertInfo> {

	public CertInfoGwtSerDer( ) {
	}

	@Override
	public net.bluemind.addressbook.api.CertInfo deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.addressbook.api.CertInfo ret = new net.bluemind.addressbook.api.CertInfo();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.addressbook.api.CertInfo ret, JSONObject json) {
		JSONValue usageJSON = json.get("usage");
		ret.usage =  new GwtSerDerUtils.SetSerDer<>(new net.bluemind.addressbook.api.gwt.serder.CertInfoCertUsageGwtSerDer()).deserialize(usageJSON);
		JSONValue x509CertificateJSON = json.get("x509Certificate");
		ret.x509Certificate =  new GwtSerDerUtils.ByteArraySerDer().deserialize(x509CertificateJSON);
	}

	public void deserializeTo(net.bluemind.addressbook.api.CertInfo ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("usage")) {
			JSONValue usageJSON = json.get("usage");
			ret.usage =  new GwtSerDerUtils.SetSerDer<>(new net.bluemind.addressbook.api.gwt.serder.CertInfoCertUsageGwtSerDer()).deserialize(usageJSON);
		}
		if (!childPropertiesToIgnore.contains("x509Certificate")) {
			JSONValue x509CertificateJSON = json.get("x509Certificate");
			ret.x509Certificate =  new GwtSerDerUtils.ByteArraySerDer().deserialize(x509CertificateJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.addressbook.api.CertInfo o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.addressbook.api.CertInfo o, JSONObject ret) {

		ret.put("usage",  new GwtSerDerUtils.SetSerDer<>(new net.bluemind.addressbook.api.gwt.serder.CertInfoCertUsageGwtSerDer()).serialize( o.usage ));
		ret.put("x509Certificate",  new GwtSerDerUtils.ByteArraySerDer().serialize( o.x509Certificate ));
	}

	public void serializeTo(net.bluemind.addressbook.api.CertInfo o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("usage")) {
			ret.put("usage",  new GwtSerDerUtils.SetSerDer<>(new net.bluemind.addressbook.api.gwt.serder.CertInfoCertUsageGwtSerDer()).serialize( o.usage ));
		}
		if (!childPropertiesToIgnore.contains("x509Certificate")) {
			ret.put("x509Certificate",  new GwtSerDerUtils.ByteArraySerDer().serialize( o.x509Certificate ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}