<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * Recipient.
 */
class Recipient  {

  /*
   * @type String
   */
  public $email;

  /*
   * @type String
   */
  public $name;

  /*
   * @type RecipientAddressType
   */
  public $addressType;

  /*
   * @type RecipientRecipientType
   */
  public $recipientType;

  /*
   * Constructor
   */
  public function __construct() {
    $this->email = "";
    $this->name = "";
  }

  public function toMap() {
    $data = array(    
        "email" => empty($this->email) ? null : $this->email,    
        "name" => empty($this->name) ? null : $this->name,    
        "addressType" => empty($this->addressType) ? null : $this->addressType,    
        "recipientType" => empty($this->recipientType) ? null : $this->recipientType);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
