<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * AssignmentActionMapping.
 */
class AssignmentActionMapping  {

  /*
   * @type String
   */
  public $assignmentUid;

  /*
   * @type String
   */
  public $actionIdentifier;

  /*
   * @type String
   */
  public $actionContext;

  /*
   * Constructor
   */
  public function __construct() {
    $this->assignmentUid = "";
    $this->actionIdentifier = "";
    $this->actionContext = "";
  }

  public function toMap() {
    $data = array(    
        "assignmentUid" => empty($this->assignmentUid) ? null : $this->assignmentUid,    
        "actionIdentifier" => empty($this->actionIdentifier) ? null : $this->actionIdentifier,    
        "actionContext" => empty($this->actionContext) ? null : $this->actionContext);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
