/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "fur" locale.
 */
public class LocalizedNamesImpl_fur extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AC",
        "AF",
        "AL",
        "DZ",
        "AD",
        "AO",
        "AI",
        "AQ",
        "AG",
        "SA",
        "AR",
        "AM",
        "AW",
        "AU",
        "AT",
        "AZ",
        "BS",
        "BH",
        "BD",
        "BB",
        "BE",
        "BZ",
        "BJ",
        "BM",
        "BT",
        "BY",
        "MM",
        "BO",
        "BA",
        "BW",
        "BQ",
        "BR",
        "BN",
        "BG",
        "BF",
        "BI",
        "TD",
        "KH",
        "CM",
        "CA",
        "EA",
        "CL",
        "CN",
        "CY",
        "CV",
        "CO",
        "KM",
        "CG",
        "KP",
        "KR",
        "CR",
        "HR",
        "CU",
        "CI",
        "CW",
        "DK",
        "DG",
        "DM",
        "EC",
        "EG",
        "SV",
        "AE",
        "ER",
        "EE",
        "ET",
        "EZ",
        "PH",
        "FI",
        "FJ",
        "FR",
        "GA",
        "GM",
        "GS",
        "GH",
        "DJ",
        "JM",
        "JP",
        "GE",
        "DE",
        "GI",
        "NC",
        "NZ",
        "GR",
        "GD",
        "GL",
        "GP",
        "GU",
        "GT",
        "GG",
        "GF",
        "GW",
        "GN",
        "GQ",
        "GY",
        "HT",
        "HN",
        "IN",
        "ID",
        "IR",
        "IQ",
        "IE",
        "IS",
        "NF",
        "IL",
        "BV",
        "CX",
        "CP",
        "IM",
        "HM",
        "AX",
        "IC",
        "KY",
        "CC",
        "CK",
        "FK",
        "FO",
        "MP",
        "MH",
        "UM",
        "SB",
        "TC",
        "VI",
        "VG",
        "IT",
        "JE",
        "JO",
        "KZ",
        "KE",
        "KG",
        "KI",
        "KW",
        "LA",
        "LS",
        "LV",
        "LB",
        "LR",
        "LY",
        "LI",
        "LT",
        "LU",
        "MK",
        "MG",
        "MW",
        "MY",
        "MV",
        "ML",
        "MT",
        "MA",
        "MQ",
        "MR",
        "MU",
        "YT",
        "MX",
        "FM",
        "MD",
        "MC",
        "MN",
        "ME",
        "MS",
        "MZ",
        "NA",
        "NR",
        "NP",
        "NI",
        "NE",
        "NG",
        "NU",
        "NO",
        "QO",
        "OM",
        "HU",
        "NL",
        "PK",
        "PW",
        "PA",
        "PG",
        "PY",
        "PE",
        "PN",
        "PF",
        "PL",
        "PR",
        "PT",
        "QA",
        "GB",
        "HK",
        "MO",
        "CZ",
        "CF",
        "CD",
        "DO",
        "RE",
        "RO",
        "RW",
        "RU",
        "EH",
        "WS",
        "AS",
        "KN",
        "SM",
        "PM",
        "BL",
        "SH",
        "LC",
        "MF",
        "VC",
        "ST",
        "SN",
        "RS",
        "SC",
        "SL",
        "SG",
        "SY",
        "SK",
        "SI",
        "SO",
        "ES",
        "LK",
        "SS",
        "US",
        "ZA",
        "SD",
        "SR",
        "SJ",
        "SE",
        "CH",
        "SZ",
        "SX",
        "TH",
        "TW",
        "TZ",
        "TJ",
        "IO",
        "TF",
        "PS",
        "TL",
        "TG",
        "TK",
        "TO",
        "TT",
        "TA",
        "TN",
        "TR",
        "TM",
        "TV",
        "UA",
        "UG",
        "UN",
        "EU",
        "UY",
        "UZ",
        "VU",
        "VA",
        "VE",
        "VN",
        "WF",
        "XA",
        "XB",
        "XK",
        "YE",
        "ZM",
        "ZW",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "Mont");
    namesMap.put("002", "Afriche");
    namesMap.put("003", "Americhe dal Nord");
    namesMap.put("005", "Americhe meridionâl");
    namesMap.put("009", "Oceanie");
    namesMap.put("011", "Afriche ocidentâl");
    namesMap.put("013", "Americhe centrâl");
    namesMap.put("014", "Afriche orientâl");
    namesMap.put("015", "Afriche setentrionâl");
    namesMap.put("017", "Afriche di mieç");
    namesMap.put("018", "Afriche meridionâl");
    namesMap.put("019", "Americhis");
    namesMap.put("021", "Americhe setentrionâl");
    namesMap.put("029", "caraibic");
    namesMap.put("030", "Asie orientâl");
    namesMap.put("034", "Asie meridionâl");
    namesMap.put("035", "Asie sud orientâl");
    namesMap.put("039", "Europe meridionâl");
    namesMap.put("053", "Australie e Gnove Zelande");
    namesMap.put("054", "Melanesie");
    namesMap.put("057", "Regjon de Micronesie");
    namesMap.put("061", "Polinesie");
    namesMap.put("142", "Asie");
    namesMap.put("143", "Asie centrâl");
    namesMap.put("145", "Asie ocidentâl");
    namesMap.put("151", "Europe orientâl");
    namesMap.put("154", "Europe setentrionâl");
    namesMap.put("155", "Europe ocidentâl");
    namesMap.put("419", "Americhe latine");
    namesMap.put("AE", "Emirâts araps unîts");
    namesMap.put("AG", "Antigua e Barbuda");
    namesMap.put("AL", "Albanie");
    namesMap.put("AM", "Armenie");
    namesMap.put("AQ", "Antartic");
    namesMap.put("AR", "Argjentine");
    namesMap.put("AS", "Samoa merecanis");
    namesMap.put("AT", "Austrie");
    namesMap.put("AU", "Australie");
    namesMap.put("AX", "Isulis Aland");
    namesMap.put("AZ", "Azerbaigian");
    namesMap.put("BA", "Bosnie e Ercegovine");
    namesMap.put("BE", "Belgjiche");
    namesMap.put("BG", "Bulgarie");
    namesMap.put("BL", "Sant Barthélemy");
    namesMap.put("BO", "Bolivie");
    namesMap.put("BR", "Brasîl");
    namesMap.put("BV", "Isule Bouvet");
    namesMap.put("BY", "Bielorussie");
    namesMap.put("CA", "Canade");
    namesMap.put("CC", "Isulis Cocos");
    namesMap.put("CD", "Republiche Democratiche dal Congo");
    namesMap.put("CF", "Republiche centri africane");
    namesMap.put("CH", "Svuizare");
    namesMap.put("CI", "Cueste di Avoli");
    namesMap.put("CK", "Isulis Cook");
    namesMap.put("CL", "Cile");
    namesMap.put("CM", "Camerun");
    namesMap.put("CN", "Cine");
    namesMap.put("CO", "Colombie");
    namesMap.put("CP", "Isule Clipperton");
    namesMap.put("CV", "Cjâf vert");
    namesMap.put("CX", "Isule Christmas");
    namesMap.put("CY", "Cipri");
    namesMap.put("CZ", "Republiche ceche");
    namesMap.put("DE", "Gjermanie");
    namesMap.put("DJ", "Gibuti");
    namesMap.put("DK", "Danimarcje");
    namesMap.put("DM", "Dominiche");
    namesMap.put("DO", "Republiche dominicane");
    namesMap.put("DZ", "Alzerie");
    namesMap.put("EA", "Ceuta e Melilla");
    namesMap.put("EE", "Estonie");
    namesMap.put("EG", "Egjit");
    namesMap.put("EH", "Sahara ocidentâl");
    namesMap.put("ER", "Eritree");
    namesMap.put("ES", "Spagne");
    namesMap.put("ET", "Etiopie");
    namesMap.put("EU", "Union europeane");
    namesMap.put("FI", "Finlandie");
    namesMap.put("FJ", "Fizi");
    namesMap.put("FK", "Isulis Falkland");
    namesMap.put("FM", "Micronesie");
    namesMap.put("FO", "Isulis Faroe");
    namesMap.put("GB", "Ream unît");
    namesMap.put("GE", "Gjeorgjie");
    namesMap.put("GF", "Guiana francês");
    namesMap.put("GI", "Gjibraltar");
    namesMap.put("GL", "Groenlande");
    namesMap.put("GN", "Guinee");
    namesMap.put("GP", "Guadalupe");
    namesMap.put("GQ", "Guinee ecuatoriâl");
    namesMap.put("GR", "Grecie");
    namesMap.put("GS", "Georgia dal Sud e Isulis Sandwich dal Sud");
    namesMap.put("HK", "Regjon aministrative speciâl de Cine di Hong Kong");
    namesMap.put("HM", "Isule Heard e Isulis McDonald");
    namesMap.put("HR", "Cravuazie");
    namesMap.put("HU", "Ongjarie");
    namesMap.put("IC", "Isulis Canariis");
    namesMap.put("ID", "Indonesie");
    namesMap.put("IE", "Irlande");
    namesMap.put("IL", "Israêl");
    namesMap.put("IM", "Isule di Man");
    namesMap.put("IO", "Teritori britanic dal Ocean Indian");
    namesMap.put("IS", "Islande");
    namesMap.put("IT", "Italie");
    namesMap.put("JM", "Gjamaiche");
    namesMap.put("JO", "Jordanie");
    namesMap.put("JP", "Gjapon");
    namesMap.put("KG", "Kirghizstan");
    namesMap.put("KH", "Camboze");
    namesMap.put("KM", "Comoris");
    namesMap.put("KN", "San Kitts e Nevis");
    namesMap.put("KP", "Coree dal nord");
    namesMap.put("KR", "Coree dal sud");
    namesMap.put("KY", "Isulis Cayman");
    namesMap.put("KZ", "Kazachistan");
    namesMap.put("LB", "Liban");
    namesMap.put("LC", "Sante Lusie");
    namesMap.put("LR", "Liberie");
    namesMap.put("LT", "Lituanie");
    namesMap.put("LU", "Lussemburc");
    namesMap.put("LV", "Letonie");
    namesMap.put("LY", "Libie");
    namesMap.put("MA", "Maroc");
    namesMap.put("MD", "Moldavie");
    namesMap.put("MF", "Sant Martin");
    namesMap.put("MH", "Isulis Marshall");
    namesMap.put("MK", "Macedonie");
    namesMap.put("MM", "Birmanie");
    namesMap.put("MN", "Mongolie");
    namesMap.put("MO", "Regjon aministrative speciâl de Cine di Macao");
    namesMap.put("MP", "Isulis Mariana dal Nord");
    namesMap.put("MQ", "Martiniche");
    namesMap.put("MR", "Mauritanie");
    namesMap.put("MU", "Maurizi");
    namesMap.put("MV", "Maldivis");
    namesMap.put("MX", "Messic");
    namesMap.put("MZ", "Mozambic");
    namesMap.put("NA", "Namibie");
    namesMap.put("NC", "Gnove Caledonie");
    namesMap.put("NF", "Isole Norfolk");
    namesMap.put("NG", "Nigerie");
    namesMap.put("NL", "Paîs bas");
    namesMap.put("NO", "Norvegje");
    namesMap.put("NZ", "Gnove Zelande");
    namesMap.put("PA", "Panamà");
    namesMap.put("PE", "Perù");
    namesMap.put("PF", "Polinesie francês");
    namesMap.put("PG", "Papue Gnove Guinee");
    namesMap.put("PH", "Filipinis");
    namesMap.put("PL", "Polonie");
    namesMap.put("PM", "San Pierre e Miquelon");
    namesMap.put("PN", "Pitcairn");
    namesMap.put("PR", "Porto Rico");
    namesMap.put("PS", "Teritoris palestinês");
    namesMap.put("QO", "Oceanie periferiche");
    namesMap.put("RE", "Reunion");
    namesMap.put("RO", "Romanie");
    namesMap.put("RS", "Serbie");
    namesMap.put("RU", "Russie");
    namesMap.put("RW", "Ruande");
    namesMap.put("SA", "Arabie Saudide");
    namesMap.put("SB", "Isulis Salomon");
    namesMap.put("SE", "Svezie");
    namesMap.put("SH", "Sante Eline");
    namesMap.put("SI", "Slovenie");
    namesMap.put("SJ", "Svalbard e Jan Mayen");
    namesMap.put("SK", "Slovachie");
    namesMap.put("SM", "San Marin");
    namesMap.put("SO", "Somalie");
    namesMap.put("ST", "Sao Tomè e Principe");
    namesMap.put("SY", "Sirie");
    namesMap.put("TC", "Isulis Turks e Caicos");
    namesMap.put("TD", "Çad");
    namesMap.put("TF", "Teritoris meridionâi francês");
    namesMap.put("TH", "Tailandie");
    namesMap.put("TJ", "Tazikistan");
    namesMap.put("TL", "Timor orientâl");
    namesMap.put("TN", "Tunisie");
    namesMap.put("TR", "Turchie");
    namesMap.put("TT", "Trinidad e Tobago");
    namesMap.put("TZ", "Tanzanie");
    namesMap.put("UA", "Ucraine");
    namesMap.put("UM", "Isulis periferichis minôrs dai Stâts Unîts");
    namesMap.put("US", "Stâts Unîts");
    namesMap.put("UZ", "Uzbechistan");
    namesMap.put("VA", "Vatican");
    namesMap.put("VC", "San Vincent e lis Grenadinis");
    namesMap.put("VG", "Isulis vergjinis britanichis");
    namesMap.put("VI", "Isulis vergjinis americanis");
    namesMap.put("WF", "Wallis e Futuna");
    namesMap.put("ZA", "Sud Afriche");
    namesMap.put("ZZ", "Regjon no cognossude o no valide");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "Mont",
        "002": "Afriche",
        "003": "Americhe dal Nord",
        "005": "Americhe meridionâl",
        "009": "Oceanie",
        "011": "Afriche ocidentâl",
        "013": "Americhe centrâl",
        "014": "Afriche orientâl",
        "015": "Afriche setentrionâl",
        "017": "Afriche di mieç",
        "018": "Afriche meridionâl",
        "019": "Americhis",
        "021": "Americhe setentrionâl",
        "029": "caraibic",
        "030": "Asie orientâl",
        "034": "Asie meridionâl",
        "035": "Asie sud orientâl",
        "039": "Europe meridionâl",
        "053": "Australie e Gnove Zelande",
        "054": "Melanesie",
        "057": "Regjon de Micronesie",
        "061": "Polinesie",
        "142": "Asie",
        "143": "Asie centrâl",
        "145": "Asie ocidentâl",
        "151": "Europe orientâl",
        "154": "Europe setentrionâl",
        "155": "Europe ocidentâl",
        "419": "Americhe latine",
        "AE": "Emirâts araps unîts",
        "AG": "Antigua e Barbuda",
        "AL": "Albanie",
        "AM": "Armenie",
        "AQ": "Antartic",
        "AR": "Argjentine",
        "AS": "Samoa merecanis",
        "AT": "Austrie",
        "AU": "Australie",
        "AX": "Isulis Aland",
        "AZ": "Azerbaigian",
        "BA": "Bosnie e Ercegovine",
        "BE": "Belgjiche",
        "BG": "Bulgarie",
        "BL": "Sant Barthélemy",
        "BO": "Bolivie",
        "BR": "Brasîl",
        "BV": "Isule Bouvet",
        "BY": "Bielorussie",
        "CA": "Canade",
        "CC": "Isulis Cocos",
        "CD": "Republiche Democratiche dal Congo",
        "CF": "Republiche centri africane",
        "CH": "Svuizare",
        "CI": "Cueste di Avoli",
        "CK": "Isulis Cook",
        "CL": "Cile",
        "CM": "Camerun",
        "CN": "Cine",
        "CO": "Colombie",
        "CP": "Isule Clipperton",
        "CV": "Cjâf vert",
        "CX": "Isule Christmas",
        "CY": "Cipri",
        "CZ": "Republiche ceche",
        "DE": "Gjermanie",
        "DJ": "Gibuti",
        "DK": "Danimarcje",
        "DM": "Dominiche",
        "DO": "Republiche dominicane",
        "DZ": "Alzerie",
        "EA": "Ceuta e Melilla",
        "EE": "Estonie",
        "EG": "Egjit",
        "EH": "Sahara ocidentâl",
        "ER": "Eritree",
        "ES": "Spagne",
        "ET": "Etiopie",
        "EU": "Union europeane",
        "FI": "Finlandie",
        "FJ": "Fizi",
        "FK": "Isulis Falkland",
        "FM": "Micronesie",
        "FO": "Isulis Faroe",
        "GB": "Ream unît",
        "GE": "Gjeorgjie",
        "GF": "Guiana francês",
        "GI": "Gjibraltar",
        "GL": "Groenlande",
        "GN": "Guinee",
        "GP": "Guadalupe",
        "GQ": "Guinee ecuatoriâl",
        "GR": "Grecie",
        "GS": "Georgia dal Sud e Isulis Sandwich dal Sud",
        "HK": "Regjon aministrative speciâl de Cine di Hong Kong",
        "HM": "Isule Heard e Isulis McDonald",
        "HR": "Cravuazie",
        "HU": "Ongjarie",
        "IC": "Isulis Canariis",
        "ID": "Indonesie",
        "IE": "Irlande",
        "IL": "Israêl",
        "IM": "Isule di Man",
        "IO": "Teritori britanic dal Ocean Indian",
        "IS": "Islande",
        "IT": "Italie",
        "JM": "Gjamaiche",
        "JO": "Jordanie",
        "JP": "Gjapon",
        "KG": "Kirghizstan",
        "KH": "Camboze",
        "KM": "Comoris",
        "KN": "San Kitts e Nevis",
        "KP": "Coree dal nord",
        "KR": "Coree dal sud",
        "KY": "Isulis Cayman",
        "KZ": "Kazachistan",
        "LB": "Liban",
        "LC": "Sante Lusie",
        "LR": "Liberie",
        "LT": "Lituanie",
        "LU": "Lussemburc",
        "LV": "Letonie",
        "LY": "Libie",
        "MA": "Maroc",
        "MD": "Moldavie",
        "MF": "Sant Martin",
        "MH": "Isulis Marshall",
        "MK": "Macedonie",
        "MM": "Birmanie",
        "MN": "Mongolie",
        "MO": "Regjon aministrative speciâl de Cine di Macao",
        "MP": "Isulis Mariana dal Nord",
        "MQ": "Martiniche",
        "MR": "Mauritanie",
        "MU": "Maurizi",
        "MV": "Maldivis",
        "MX": "Messic",
        "MZ": "Mozambic",
        "NA": "Namibie",
        "NC": "Gnove Caledonie",
        "NF": "Isole Norfolk",
        "NG": "Nigerie",
        "NL": "Paîs bas",
        "NO": "Norvegje",
        "NZ": "Gnove Zelande",
        "PA": "Panamà",
        "PE": "Perù",
        "PF": "Polinesie francês",
        "PG": "Papue Gnove Guinee",
        "PH": "Filipinis",
        "PL": "Polonie",
        "PM": "San Pierre e Miquelon",
        "PN": "Pitcairn",
        "PR": "Porto Rico",
        "PS": "Teritoris palestinês",
        "QO": "Oceanie periferiche",
        "RE": "Reunion",
        "RO": "Romanie",
        "RS": "Serbie",
        "RU": "Russie",
        "RW": "Ruande",
        "SA": "Arabie Saudide",
        "SB": "Isulis Salomon",
        "SE": "Svezie",
        "SH": "Sante Eline",
        "SI": "Slovenie",
        "SJ": "Svalbard e Jan Mayen",
        "SK": "Slovachie",
        "SM": "San Marin",
        "SO": "Somalie",
        "ST": "Sao Tomè e Principe",
        "SY": "Sirie",
        "TC": "Isulis Turks e Caicos",
        "TD": "Çad",
        "TF": "Teritoris meridionâi francês",
        "TH": "Tailandie",
        "TJ": "Tazikistan",
        "TL": "Timor orientâl",
        "TN": "Tunisie",
        "TR": "Turchie",
        "TT": "Trinidad e Tobago",
        "TZ": "Tanzanie",
        "UA": "Ucraine",
        "UM": "Isulis periferichis minôrs dai Stâts Unîts",
        "US": "Stâts Unîts",
        "UZ": "Uzbechistan",
        "VA": "Vatican",
        "VC": "San Vincent e lis Grenadinis",
        "VG": "Isulis vergjinis britanichis",
        "VI": "Isulis vergjinis americanis",
        "WF": "Wallis e Futuna",
        "ZA": "Sud Afriche",
        "ZZ": "Regjon no cognossude o no valide"
    };
  }-*/;
}
