/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.calendar.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class VFreebusyQueryGwtSerDer implements GwtSerDer<net.bluemind.calendar.api.VFreebusyQuery> {

	public VFreebusyQueryGwtSerDer( ) {
	}

	@Override
	public net.bluemind.calendar.api.VFreebusyQuery deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.calendar.api.VFreebusyQuery ret = new net.bluemind.calendar.api.VFreebusyQuery();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.calendar.api.VFreebusyQuery ret, JSONObject json) {
		JSONValue dtstartJSON = json.get("dtstart");
		ret.dtstart =  new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer().deserialize(dtstartJSON);
		JSONValue dtendJSON = json.get("dtend");
		ret.dtend =  new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer().deserialize(dtendJSON);
		JSONValue excludedEventsJSON = json.get("excludedEvents");
		ret.excludedEvents =  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).deserialize(excludedEventsJSON);
		JSONValue withOOFSlotsJSON = json.get("withOOFSlots");
		ret.withOOFSlots =  GwtSerDerUtils.BOOLEAN.deserialize(withOOFSlotsJSON);
	}

	public void deserializeTo(net.bluemind.calendar.api.VFreebusyQuery ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("dtstart")) {
			JSONValue dtstartJSON = json.get("dtstart");
			ret.dtstart =  new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer().deserialize(dtstartJSON);
		}
		if (!childPropertiesToIgnore.contains("dtend")) {
			JSONValue dtendJSON = json.get("dtend");
			ret.dtend =  new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer().deserialize(dtendJSON);
		}
		if (!childPropertiesToIgnore.contains("excludedEvents")) {
			JSONValue excludedEventsJSON = json.get("excludedEvents");
			ret.excludedEvents =  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).deserialize(excludedEventsJSON);
		}
		if (!childPropertiesToIgnore.contains("withOOFSlots")) {
			JSONValue withOOFSlotsJSON = json.get("withOOFSlots");
			ret.withOOFSlots =  GwtSerDerUtils.BOOLEAN.deserialize(withOOFSlotsJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.calendar.api.VFreebusyQuery o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.calendar.api.VFreebusyQuery o, JSONObject ret) {

		ret.put("dtstart",  new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer().serialize( o.dtstart ));
		ret.put("dtend",  new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer().serialize( o.dtend ));
		ret.put("excludedEvents",  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).serialize( o.excludedEvents ));
		ret.put("withOOFSlots",  GwtSerDerUtils.BOOLEAN.serialize( o.withOOFSlots ));
	}

	public void serializeTo(net.bluemind.calendar.api.VFreebusyQuery o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("dtstart")) {
			ret.put("dtstart",  new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer().serialize( o.dtstart ));
		}
		if (!childPropertiesToIgnore.contains("dtend")) {
			ret.put("dtend",  new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer().serialize( o.dtend ));
		}
		if (!childPropertiesToIgnore.contains("excludedEvents")) {
			ret.put("excludedEvents",  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).serialize( o.excludedEvents ));
		}
		if (!childPropertiesToIgnore.contains("withOOFSlots")) {
			ret.put("withOOFSlots",  GwtSerDerUtils.BOOLEAN.serialize( o.withOOFSlots ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}