/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.calendar.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class VEventSeriesGwtSerDer implements GwtSerDer<net.bluemind.calendar.api.VEventSeries> {

	public VEventSeriesGwtSerDer( ) {
	}

	@Override
	public net.bluemind.calendar.api.VEventSeries deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.calendar.api.VEventSeries ret = new net.bluemind.calendar.api.VEventSeries();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.calendar.api.VEventSeries ret, JSONObject json) {
		JSONValue mainJSON = json.get("main");
		ret.main =  new net.bluemind.calendar.api.gwt.serder.VEventGwtSerDer().deserialize(mainJSON);
		JSONValue occurrencesJSON = json.get("occurrences");
		ret.occurrences =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.calendar.api.gwt.serder.VEventOccurrenceGwtSerDer()).deserialize(occurrencesJSON);
		JSONValue countersJSON = json.get("counters");
		ret.counters =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.calendar.api.gwt.serder.VEventCounterGwtSerDer()).deserialize(countersJSON);
		JSONValue propertiesJSON = json.get("properties");
		ret.properties =  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).deserialize(propertiesJSON);
		JSONValue icsUidJSON = json.get("icsUid");
		ret.icsUid =  GwtSerDerUtils.STRING.deserialize(icsUidJSON);
		JSONValue acceptCountersJSON = json.get("acceptCounters");
		ret.acceptCounters =  GwtSerDerUtils.BOOLEAN.deserialize(acceptCountersJSON);
	}

	public void deserializeTo(net.bluemind.calendar.api.VEventSeries ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("main")) {
			JSONValue mainJSON = json.get("main");
			ret.main =  new net.bluemind.calendar.api.gwt.serder.VEventGwtSerDer().deserialize(mainJSON);
		}
		if (!childPropertiesToIgnore.contains("occurrences")) {
			JSONValue occurrencesJSON = json.get("occurrences");
			ret.occurrences =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.calendar.api.gwt.serder.VEventOccurrenceGwtSerDer()).deserialize(occurrencesJSON);
		}
		if (!childPropertiesToIgnore.contains("counters")) {
			JSONValue countersJSON = json.get("counters");
			ret.counters =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.calendar.api.gwt.serder.VEventCounterGwtSerDer()).deserialize(countersJSON);
		}
		if (!childPropertiesToIgnore.contains("properties")) {
			JSONValue propertiesJSON = json.get("properties");
			ret.properties =  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).deserialize(propertiesJSON);
		}
		if (!childPropertiesToIgnore.contains("icsUid")) {
			JSONValue icsUidJSON = json.get("icsUid");
			ret.icsUid =  GwtSerDerUtils.STRING.deserialize(icsUidJSON);
		}
		if (!childPropertiesToIgnore.contains("acceptCounters")) {
			JSONValue acceptCountersJSON = json.get("acceptCounters");
			ret.acceptCounters =  GwtSerDerUtils.BOOLEAN.deserialize(acceptCountersJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.calendar.api.VEventSeries o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.calendar.api.VEventSeries o, JSONObject ret) {

		ret.put("main",  new net.bluemind.calendar.api.gwt.serder.VEventGwtSerDer().serialize( o.main ));
		ret.put("occurrences",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.calendar.api.gwt.serder.VEventOccurrenceGwtSerDer()).serialize( o.occurrences ));
		ret.put("counters",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.calendar.api.gwt.serder.VEventCounterGwtSerDer()).serialize( o.counters ));
		ret.put("properties",  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).serialize( o.properties ));
		ret.put("icsUid",  GwtSerDerUtils.STRING.serialize( o.icsUid ));
		ret.put("acceptCounters",  GwtSerDerUtils.BOOLEAN.serialize( o.acceptCounters ));
	}

	public void serializeTo(net.bluemind.calendar.api.VEventSeries o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("main")) {
			ret.put("main",  new net.bluemind.calendar.api.gwt.serder.VEventGwtSerDer().serialize( o.main ));
		}
		if (!childPropertiesToIgnore.contains("occurrences")) {
			ret.put("occurrences",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.calendar.api.gwt.serder.VEventOccurrenceGwtSerDer()).serialize( o.occurrences ));
		}
		if (!childPropertiesToIgnore.contains("counters")) {
			ret.put("counters",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.calendar.api.gwt.serder.VEventCounterGwtSerDer()).serialize( o.counters ));
		}
		if (!childPropertiesToIgnore.contains("properties")) {
			ret.put("properties",  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).serialize( o.properties ));
		}
		if (!childPropertiesToIgnore.contains("icsUid")) {
			ret.put("icsUid",  GwtSerDerUtils.STRING.serialize( o.icsUid ));
		}
		if (!childPropertiesToIgnore.contains("acceptCounters")) {
			ret.put("acceptCounters",  GwtSerDerUtils.BOOLEAN.serialize( o.acceptCounters ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}