/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.calendar.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class VEventOccurrenceGwtSerDer implements GwtSerDer<net.bluemind.calendar.api.VEventOccurrence> {

	private net.bluemind.calendar.api.gwt.serder.VEventGwtSerDer parent = new  net.bluemind.calendar.api.gwt.serder.VEventGwtSerDer();
	public VEventOccurrenceGwtSerDer( ) {
	}

	@Override
	public net.bluemind.calendar.api.VEventOccurrence deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.calendar.api.VEventOccurrence ret = new net.bluemind.calendar.api.VEventOccurrence();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.calendar.api.VEventOccurrence ret, JSONObject json) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		parent.deserializeTo( ret, json, propertiesToIgnore);
		JSONValue recuridJSON = json.get("recurid");
		ret.recurid =  new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer().deserialize(recuridJSON);
	}

	public void deserializeTo(net.bluemind.calendar.api.VEventOccurrence ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		propertiesToIgnore.addAll(childPropertiesToIgnore);
		parent.deserializeTo( ret, json, propertiesToIgnore);
		if (!childPropertiesToIgnore.contains("recurid")) {
			JSONValue recuridJSON = json.get("recurid");
			ret.recurid =  new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer().deserialize(recuridJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.calendar.api.VEventOccurrence o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.calendar.api.VEventOccurrence o, JSONObject ret) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		parent.serializeTo( o, ret, propertiesToIgnore);

		ret.put("recurid",  new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer().serialize( o.recurid ));
	}

	public void serializeTo(net.bluemind.calendar.api.VEventOccurrence o, JSONObject ret, Set<String> childPropertiesToIgnore) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		propertiesToIgnore.addAll(childPropertiesToIgnore);
		parent.serializeTo( o, ret, propertiesToIgnore);

		if (!childPropertiesToIgnore.contains("recurid")) {
			ret.put("recurid",  new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer().serialize( o.recurid ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}