/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.calendar.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class VEventCounterGwtSerDer implements GwtSerDer<net.bluemind.calendar.api.VEventCounter> {

	public VEventCounterGwtSerDer( ) {
	}

	@Override
	public net.bluemind.calendar.api.VEventCounter deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.calendar.api.VEventCounter ret = new net.bluemind.calendar.api.VEventCounter();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.calendar.api.VEventCounter ret, JSONObject json) {
		JSONValue originatorJSON = json.get("originator");
		ret.originator =  new net.bluemind.calendar.api.gwt.serder.VEventCounterCounterOriginatorGwtSerDer().deserialize(originatorJSON);
		JSONValue counterJSON = json.get("counter");
		ret.counter =  new net.bluemind.calendar.api.gwt.serder.VEventOccurrenceGwtSerDer().deserialize(counterJSON);
	}

	public void deserializeTo(net.bluemind.calendar.api.VEventCounter ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("originator")) {
			JSONValue originatorJSON = json.get("originator");
			ret.originator =  new net.bluemind.calendar.api.gwt.serder.VEventCounterCounterOriginatorGwtSerDer().deserialize(originatorJSON);
		}
		if (!childPropertiesToIgnore.contains("counter")) {
			JSONValue counterJSON = json.get("counter");
			ret.counter =  new net.bluemind.calendar.api.gwt.serder.VEventOccurrenceGwtSerDer().deserialize(counterJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.calendar.api.VEventCounter o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.calendar.api.VEventCounter o, JSONObject ret) {

		ret.put("originator",  new net.bluemind.calendar.api.gwt.serder.VEventCounterCounterOriginatorGwtSerDer().serialize( o.originator ));
		ret.put("counter",  new net.bluemind.calendar.api.gwt.serder.VEventOccurrenceGwtSerDer().serialize( o.counter ));
	}

	public void serializeTo(net.bluemind.calendar.api.VEventCounter o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("originator")) {
			ret.put("originator",  new net.bluemind.calendar.api.gwt.serder.VEventCounterCounterOriginatorGwtSerDer().serialize( o.originator ));
		}
		if (!childPropertiesToIgnore.contains("counter")) {
			ret.put("counter",  new net.bluemind.calendar.api.gwt.serder.VEventOccurrenceGwtSerDer().serialize( o.counter ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}