/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.calendar.api.gwt.endpoint;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.http.client.URL;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.lang.Long;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.api.Stream;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;

public class CalendarsSockJsEndpoint implements net.bluemind.calendar.api.ICalendarsAsync {

	private String rootUri = "/api";

	private String baseUri;

    private String sessionId;

	public CalendarsSockJsEndpoint(String sessionId, String... pathVars) {
		String uri_ = "/calendars";
		this.sessionId = sessionId;
	

		baseUri = uri_;
	}

	public CalendarsSockJsEndpoint withRoot(String root) {
		this.rootUri = root;
		return this;
	}

	@Override
	public void search(net.bluemind.calendar.api.CalendarsVEventQuery query, final AsyncHandler<List<net.bluemind.core.container.model.ItemContainerValue<net.bluemind.calendar.api.VEventSeries>>> handler) {
		String postUri = "/_search";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new net.bluemind.calendar.api.gwt.serder.CalendarsVEventQueryGwtSerDer().serialize( query);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<List<net.bluemind.core.container.model.ItemContainerValue<net.bluemind.calendar.api.VEventSeries>>>(handler) {
					@Override
			protected List<net.bluemind.core.container.model.ItemContainerValue<net.bluemind.calendar.api.VEventSeries>> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(new net.bluemind.core.container.model.gwt.serder.ItemContainerValueGwtSerDer<>(new net.bluemind.calendar.api.gwt.serder.VEventSeriesGwtSerDer())).deserialize( jsonValue );
			}
		});

	}


	@Override
	public void searchPendingCounters(List<String> calendars, final AsyncHandler<List<net.bluemind.core.container.model.ItemContainerValue<net.bluemind.calendar.api.VEventSeries>>> handler) {
		String postUri = "/_search_counters";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).serialize( calendars);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<List<net.bluemind.core.container.model.ItemContainerValue<net.bluemind.calendar.api.VEventSeries>>>(handler) {
					@Override
			protected List<net.bluemind.core.container.model.ItemContainerValue<net.bluemind.calendar.api.VEventSeries>> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(new net.bluemind.core.container.model.gwt.serder.ItemContainerValueGwtSerDer<>(new net.bluemind.calendar.api.gwt.serder.VEventSeriesGwtSerDer())).deserialize( jsonValue );
			}
		});

	}

	public net.bluemind.calendar.api.ICalendarsPromise promiseApi() {
		return new CalendarsEndpointPromise(this);
	}

}
