/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.calendar.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONValue;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;

public class CalendarsGwtEndpoint implements net.bluemind.calendar.api.ICalendarsAsync {

	private String baseUri;

	private String sessionId;

	private String root = "/api";

	public CalendarsGwtEndpoint(String sessionId, String... pathVars) {
		String uri_ = "/calendars";
		this.sessionId = sessionId;
	

		baseUri = uri_;
	}

	public CalendarsGwtEndpoint withRoot(String root) {
		this.root = root;
		return this;
	}

	@Override
	public void search(net.bluemind.calendar.api.CalendarsVEventQuery query, final AsyncHandler<List<net.bluemind.core.container.model.ItemContainerValue<net.bluemind.calendar.api.VEventSeries>>> handler) {
		String postUri = "/_search";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new net.bluemind.calendar.api.gwt.serder.CalendarsVEventQueryGwtSerDer().serialize( query);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<List<net.bluemind.core.container.model.ItemContainerValue<net.bluemind.calendar.api.VEventSeries>>>(handler) {
			@Override
			protected List<net.bluemind.core.container.model.ItemContainerValue<net.bluemind.calendar.api.VEventSeries>> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(new net.bluemind.core.container.model.gwt.serder.ItemContainerValueGwtSerDer<>(new net.bluemind.calendar.api.gwt.serder.VEventSeriesGwtSerDer())).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void searchPendingCounters(List<String> calendars, final AsyncHandler<List<net.bluemind.core.container.model.ItemContainerValue<net.bluemind.calendar.api.VEventSeries>>> handler) {
		String postUri = "/_search_counters";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).serialize( calendars);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<List<net.bluemind.core.container.model.ItemContainerValue<net.bluemind.calendar.api.VEventSeries>>>(handler) {
			@Override
			protected List<net.bluemind.core.container.model.ItemContainerValue<net.bluemind.calendar.api.VEventSeries>> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(new net.bluemind.core.container.model.gwt.serder.ItemContainerValueGwtSerDer<>(new net.bluemind.calendar.api.gwt.serder.VEventSeriesGwtSerDer())).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}

	public net.bluemind.calendar.api.ICalendarsPromise promiseApi() {
		return new CalendarsEndpointPromise(this);
	}
}
