/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.calendar.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;
import java.util.concurrent.CompletableFuture;

public class CalendarSettingsEndpointPromise implements net.bluemind.calendar.api.ICalendarSettingsPromise {

	private net.bluemind.calendar.api.ICalendarSettingsAsync impl;

	public CalendarSettingsEndpointPromise(net.bluemind.calendar.api.ICalendarSettingsAsync impl) {
		this.impl = impl;
	}

	@Override
	public CompletableFuture<net.bluemind.calendar.api.CalendarSettingsData> get() {
		
		CompletableFuture<net.bluemind.calendar.api.CalendarSettingsData> ret = new CompletableFuture<net.bluemind.calendar.api.CalendarSettingsData>();
		AsyncHandler<net.bluemind.calendar.api.CalendarSettingsData> handler = new AsyncHandler<net.bluemind.calendar.api.CalendarSettingsData>() {
			public void success(net.bluemind.calendar.api.CalendarSettingsData value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.get( handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> set(net.bluemind.calendar.api.CalendarSettingsData settings  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.set(settings,  handler);
		return ret;
	}

}
