/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.calendar.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONValue;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;

public class CalendarAutocompleteGwtEndpoint implements net.bluemind.calendar.api.ICalendarAutocompleteAsync {

	private String baseUri;

	private String sessionId;

	private String root = "/api";

	public CalendarAutocompleteGwtEndpoint(String sessionId, String... pathVars) {
		String uri_ = "/calendar/autocomplete";
		this.sessionId = sessionId;
	

		baseUri = uri_;
	}

	public CalendarAutocompleteGwtEndpoint withRoot(String root) {
		this.root = root;
		return this;
	}

	@Override
	public void calendarGroupLookup(String groupUid, final AsyncHandler<List<net.bluemind.calendar.api.CalendarLookupResponse>> handler) {
		String postUri = "/_calendarsGroupLookup/{groupUid}";

		postUri = postUri.replace("{groupUid}", URL.encodePathSegment(""+groupUid));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<List<net.bluemind.calendar.api.CalendarLookupResponse>>(handler) {
			@Override
			protected List<net.bluemind.calendar.api.CalendarLookupResponse> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(new net.bluemind.calendar.api.gwt.serder.CalendarLookupResponseGwtSerDer()).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void calendarLookup(String pattern, net.bluemind.core.container.model.acl.Verb verb, final AsyncHandler<List<net.bluemind.calendar.api.CalendarLookupResponse>> handler) {
		String postUri = "/_calendarLookup/{pattern}";

		postUri = postUri.replace("{pattern}", URL.encodePathSegment(""+pattern));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new net.bluemind.core.container.model.acl.gwt.serder.VerbGwtSerDer().serialize( verb);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<List<net.bluemind.calendar.api.CalendarLookupResponse>>(handler) {
			@Override
			protected List<net.bluemind.calendar.api.CalendarLookupResponse> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(new net.bluemind.calendar.api.gwt.serder.CalendarLookupResponseGwtSerDer()).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}

	public net.bluemind.calendar.api.ICalendarAutocompletePromise promiseApi() {
		return new CalendarAutocompleteEndpointPromise(this);
	}
}
