/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.calendar.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;
import java.util.concurrent.CompletableFuture;

public class CalendarAutocompleteEndpointPromise implements net.bluemind.calendar.api.ICalendarAutocompletePromise {

	private net.bluemind.calendar.api.ICalendarAutocompleteAsync impl;

	public CalendarAutocompleteEndpointPromise(net.bluemind.calendar.api.ICalendarAutocompleteAsync impl) {
		this.impl = impl;
	}

	@Override
	public CompletableFuture<List<net.bluemind.calendar.api.CalendarLookupResponse>> calendarGroupLookup(String groupUid  ) {
		
		CompletableFuture<List<net.bluemind.calendar.api.CalendarLookupResponse>> ret = new CompletableFuture<List<net.bluemind.calendar.api.CalendarLookupResponse>>();
		AsyncHandler<List<net.bluemind.calendar.api.CalendarLookupResponse>> handler = new AsyncHandler<List<net.bluemind.calendar.api.CalendarLookupResponse>>() {
			public void success(List<net.bluemind.calendar.api.CalendarLookupResponse> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.calendarGroupLookup(groupUid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<net.bluemind.calendar.api.CalendarLookupResponse>> calendarLookup(String pattern ,  net.bluemind.core.container.model.acl.Verb verb  ) {
		
		CompletableFuture<List<net.bluemind.calendar.api.CalendarLookupResponse>> ret = new CompletableFuture<List<net.bluemind.calendar.api.CalendarLookupResponse>>();
		AsyncHandler<List<net.bluemind.calendar.api.CalendarLookupResponse>> handler = new AsyncHandler<List<net.bluemind.calendar.api.CalendarLookupResponse>>() {
			public void success(List<net.bluemind.calendar.api.CalendarLookupResponse> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.calendarLookup(pattern, verb,  handler);
		return ret;
	}

}
