/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.scheduledjob.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class JobQueryGwtSerDer implements GwtSerDer<net.bluemind.scheduledjob.api.JobQuery> {

	public JobQueryGwtSerDer( ) {
	}

	@Override
	public net.bluemind.scheduledjob.api.JobQuery deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.scheduledjob.api.JobQuery ret = new net.bluemind.scheduledjob.api.JobQuery();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.scheduledjob.api.JobQuery ret, JSONObject json) {
		JSONValue jobIdJSON = json.get("jobId");
		ret.jobId =  GwtSerDerUtils.STRING.deserialize(jobIdJSON);
		JSONValue statusesJSON = json.get("statuses");
		ret.statuses =  new GwtSerDerUtils.SetSerDer<>(new net.bluemind.scheduledjob.api.gwt.serder.JobExitStatusGwtSerDer()).deserialize(statusesJSON);
		JSONValue domainJSON = json.get("domain");
		ret.domain =  GwtSerDerUtils.STRING.deserialize(domainJSON);
	}

	public void deserializeTo(net.bluemind.scheduledjob.api.JobQuery ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("jobId")) {
			JSONValue jobIdJSON = json.get("jobId");
			ret.jobId =  GwtSerDerUtils.STRING.deserialize(jobIdJSON);
		}
		if (!childPropertiesToIgnore.contains("statuses")) {
			JSONValue statusesJSON = json.get("statuses");
			ret.statuses =  new GwtSerDerUtils.SetSerDer<>(new net.bluemind.scheduledjob.api.gwt.serder.JobExitStatusGwtSerDer()).deserialize(statusesJSON);
		}
		if (!childPropertiesToIgnore.contains("domain")) {
			JSONValue domainJSON = json.get("domain");
			ret.domain =  GwtSerDerUtils.STRING.deserialize(domainJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.scheduledjob.api.JobQuery o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.scheduledjob.api.JobQuery o, JSONObject ret) {

		ret.put("jobId",  GwtSerDerUtils.STRING.serialize( o.jobId ));
		ret.put("statuses",  new GwtSerDerUtils.SetSerDer<>(new net.bluemind.scheduledjob.api.gwt.serder.JobExitStatusGwtSerDer()).serialize( o.statuses ));
		ret.put("domain",  GwtSerDerUtils.STRING.serialize( o.domain ));
	}

	public void serializeTo(net.bluemind.scheduledjob.api.JobQuery o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("jobId")) {
			ret.put("jobId",  GwtSerDerUtils.STRING.serialize( o.jobId ));
		}
		if (!childPropertiesToIgnore.contains("statuses")) {
			ret.put("statuses",  new GwtSerDerUtils.SetSerDer<>(new net.bluemind.scheduledjob.api.gwt.serder.JobExitStatusGwtSerDer()).serialize( o.statuses ));
		}
		if (!childPropertiesToIgnore.contains("domain")) {
			ret.put("domain",  GwtSerDerUtils.STRING.serialize( o.domain ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}