/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.scheduledjob.api.gwt.js;

import com.google.gwt.core.client.JavaScriptObject;

public class JsJobExecution extends JavaScriptObject {

	protected JsJobExecution() {}

	public final native com.google.gwt.core.client.JsDate getStartDate()
	/*-{
       if(this["startDate"]) {
          return new Date(this["startDate"]);
       } else {
          return null;
       }
	}-*/;

	public final native void setStartDate(com.google.gwt.core.client.JsDate startDate)
	/*-{
       this["startDate"] =  ( startDate != null) ? startDate.getTime() : null;
	}-*/;

	public final native com.google.gwt.core.client.JsDate getEndDate()
	/*-{
       if(this["endDate"]) {
          return new Date(this["endDate"]);
       } else {
          return null;
       }
	}-*/;

	public final native void setEndDate(com.google.gwt.core.client.JsDate endDate)
	/*-{
       this["endDate"] =  ( endDate != null) ? endDate.getTime() : null;
	}-*/;

	public final native String getDomainUid()
	/*-{
	return this["domainUid"];
	}-*/;

	public final native void setDomainUid(String domainUid)
	/*-{
       this["domainUid"] = domainUid;
	}-*/;

	public final native net.bluemind.scheduledjob.api.gwt.js.JsJobExitStatus getStatus()
	/*-{
	return this["status"];
	}-*/;

	public final native void setStatus(net.bluemind.scheduledjob.api.gwt.js.JsJobExitStatus status)
	/*-{
       this["status"] = status;
	}-*/;

	public final native String getJobId()
	/*-{
	return this["jobId"];
	}-*/;

	public final native void setJobId(String jobId)
	/*-{
       this["jobId"] = jobId;
	}-*/;

	public final native String getExecGroup()
	/*-{
	return this["execGroup"];
	}-*/;

	public final native void setExecGroup(String execGroup)
	/*-{
       this["execGroup"] = execGroup;
	}-*/;

	public final native int getId()
	/*-{
	return this["id"];
	}-*/;

	public final native void setId(int id)
	/*-{
       this["id"] = id;
	}-*/;

	public static native  JsJobExecution create()
	/*-{
       var ret = {};
       return ret;
	}-*/;

}