<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * FileHostingInfo.
 */
class FileHostingInfo  {

  /*
   * @type boolean
   */
  public $present;

  /*
   * @type FileHostingInfoType
   */
  public $type;

  /*
   * @type String
   */
  public $info;

  /*
   * @type boolean
   */
  public $browsable;

  /*
   * Constructor
   */
  public function __construct() {
    $this->present = false;
    $this->info = "";
    $this->browsable = false;
  }

  public function toMap() {
    $data = array(    
        "present" => empty($this->present) ? null : $this->present,    
        "type" => empty($this->type) ? null : $this->type,    
        "info" => empty($this->info) ? null : $this->info,    
        "browsable" => empty($this->browsable) ? null : $this->browsable);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
