/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2023
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.core.auditlogs;

import net.bluemind.core.api.BMApi;

@BMApi(version = "3")
public class AuditLogQuery {

	public String domainUid;
	public String author;
	public String with;
	public String description;
	public String container;
	public String key;
	public String[] logtypes;
	public String itemUid;
	public String containerUid;
	public String containerOwner;
	public String containerName;
	public long containerId;
	public long after;
	public long before;
	public long itemId;
	public int size = 10;

	public AuditLogQuery() {

	}

	public AuditLogQuery(LogMailQueryBuilder builder) {
		domainUid = builder.domainUid;
		author = builder.author;
		with = builder.with;
		description = builder.description;
		container = builder.container;
		key = builder.key;
		logtypes = builder.logtypes;
		itemUid = builder.itemUid;
		size = builder.size;
		containerUid = builder.containerUid;
		itemId = builder.itemId;
		after = builder.after;
		before = builder.before;
		containerId = builder.containerId;
		containerOwner = builder.containerOwner;
		containerName = builder.containerName;
	}

	public static class LogMailQueryBuilder {
		public String domainUid;
		String author;
		String with;
		String description;
		String container;
		String key;
		String[] logtypes;
		String containerOwner;
		String containerName;
		private String itemUid;
		private String containerUid;
		private long containerId;
		private long after;
		private long before;
		private long itemId;
		int size;

		public LogMailQueryBuilder domainUid(String d) {
			domainUid = d;
			return this;
		}

		public LogMailQueryBuilder author(String a) {
			author = a;
			return this;
		}

		public LogMailQueryBuilder with(String w) {
			with = w;
			return this;
		}

		public LogMailQueryBuilder description(String d) {
			description = d;
			return this;
		}

		public LogMailQueryBuilder container(String c) {
			container = c;
			return this;
		}

		public LogMailQueryBuilder key(String k) {
			key = k;
			return this;
		}

		public LogMailQueryBuilder logtypes(String... l) {
			logtypes = l;
			return this;
		}

		public LogMailQueryBuilder size(int s) {
			size = s;
			return this;
		}

		public LogMailQueryBuilder itemUid(String u) {
			itemUid = u;
			return this;
		}

		public LogMailQueryBuilder itemId(long i) {
			itemId = i;
			return this;
		}

		public LogMailQueryBuilder after(long t) {
			after = t;
			return this;
		}

		public LogMailQueryBuilder before(long t) {
			before = t;
			return this;
		}

		public LogMailQueryBuilder containerUid(String u) {
			containerUid = u;
			return this;
		}

		public LogMailQueryBuilder containerName(String n) {
			containerName = n;
			return this;
		}

		public LogMailQueryBuilder containerId(long l) {
			containerId = l;
			return this;
		}

		public LogMailQueryBuilder containerOwner(String o) {
			containerOwner = o;
			return this;
		}

		public AuditLogQuery build() {
			return new AuditLogQuery(this);
		}

	}

	@Override
	public String toString() {
		return "domainUid: " + domainUid + " ,logtypes: " + logtypes + " ,author: " + author + " ,with: " + with
				+ " ,itemUid: " + itemUid + " ,itemId: " + itemId + " ,containerUid: " + containerUid
				+ " ,containerOwner: " + containerOwner + " ,containerId: " + containerId + " ,description: "
				+ description + " ,key:" + key + " ,after: " + after + " ,before: " + before + " ,size: " + size;
	}

}
