/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.backend.mail.cql.store.factories;

import net.bluemind.backend.mail.cql.store.CqlMailboxRecordExpungedStore;
import net.bluemind.backend.mail.repository.IMailboxRecordExpungedStore;
import net.bluemind.core.api.fault.ServerFault;
import net.bluemind.core.rest.BmContext;
import net.bluemind.cql.CqlSessions;
import net.bluemind.cql.persistence.CqlRepositoryFactory;
import net.bluemind.repository.provider.IStandaloneFactory;

public class GlobalExpungedFactory extends CqlRepositoryFactory<IMailboxRecordExpungedStore>
		implements IStandaloneFactory<IMailboxRecordExpungedStore> {

	@Override
	public Class<IMailboxRecordExpungedStore> factoryClass() {
		return IMailboxRecordExpungedStore.class;
	}

	@Override
	public IMailboxRecordExpungedStore instance(BmContext context) throws ServerFault {
		return new CqlMailboxRecordExpungedStore(CqlSessions.forKeyspace("core"));
	}

}
