/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.backend.mail.cql.store;

import java.util.Collections;
import java.util.List;
import java.util.Set;

import com.datastax.oss.driver.api.core.CqlSession;

import net.bluemind.core.container.model.Container;
import net.bluemind.core.container.model.Item;
import net.bluemind.cql.persistence.CqlAbstractStore;

public class LabelsCqlStore extends CqlAbstractStore {

	private final long contId;
	private final long itemId;

	protected LabelsCqlStore(CqlSession s, Container subtree, Item folder) {
		super(s);
		this.contId = subtree.id;
		this.itemId = folder.id;
	}

	public void init() {
		reset();
	}

	public void reset() {
		voidCql("UPDATE t_mailbox_replica set labels=? WHERE container_id=? and item_id=?", Collections.emptySet(),
				contId, itemId);
	}

	public List<String> getUnique() {
		Set<String> labels = unique("SELECT labels FROM t_mailbox_replica WHERE container_id=? and item_id=?",
				r -> r.getSet(0, String.class), voidPop(), contId, itemId);
		return labels.stream().sorted().toList();

	}

	public void addSome(Set<String> labels) {
		voidCql("""
				UPDATE t_mailbox_replica SET labels = labels + ? WHERE container_id=? and item_id=?
				""", labels, contId, itemId);

	}

}