/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.system.api.hot.upgrade.gwt.js;

import com.google.gwt.core.client.JavaScriptObject;

public class JsHotUpgradeStepEventStatus extends JavaScriptObject {

	protected JsHotUpgradeStepEventStatus() {}

   public final native String value() 
   /*-{
   	return this;
   }-*/;

	public static final native JsHotUpgradeStepEventStatus NOT_STARTED()
	/*-{
		return "NOT_STARTED";
	}-*/;

	public static final native JsHotUpgradeStepEventStatus SUCCESS()
	/*-{
		return "SUCCESS";
	}-*/;

	public static final native JsHotUpgradeStepEventStatus ERROR()
	/*-{
		return "ERROR";
	}-*/;

	public static final native JsHotUpgradeStepEventStatus IN_PROGRESS()
	/*-{
		return "IN_PROGRESS";
	}-*/;

	public static final JsHotUpgradeStepEventStatus create(net.bluemind.system.api.hot.upgrade.HotUpgradeStepEvent.Status value) {
		if (value == null) {
			return null;
		} else {
			switch (value) {
			case NOT_STARTED:
				return NOT_STARTED();
			case SUCCESS:
				return SUCCESS();
			case ERROR:
				return ERROR();
			case IN_PROGRESS:
				return IN_PROGRESS();
			default:
				return null;
			}
		}
	}
}