/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.system.api.hot.upgrade.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;
import java.util.concurrent.CompletableFuture;

public class InternalHotUpgradeEndpointPromise implements net.bluemind.system.api.hot.upgrade.IInternalHotUpgradePromise {

	private net.bluemind.system.api.hot.upgrade.IInternalHotUpgradeAsync impl;

	public InternalHotUpgradeEndpointPromise(net.bluemind.system.api.hot.upgrade.IInternalHotUpgradeAsync impl) {
		this.impl = impl;
	}

	@Override
	public CompletableFuture<List<net.bluemind.system.api.hot.upgrade.HotUpgradeTask>> list(net.bluemind.system.api.hot.upgrade.HotUpgradeTaskFilter filter  ) {
		
		CompletableFuture<List<net.bluemind.system.api.hot.upgrade.HotUpgradeTask>> ret = new CompletableFuture<List<net.bluemind.system.api.hot.upgrade.HotUpgradeTask>>();
		AsyncHandler<List<net.bluemind.system.api.hot.upgrade.HotUpgradeTask>> handler = new AsyncHandler<List<net.bluemind.system.api.hot.upgrade.HotUpgradeTask>>() {
			public void success(List<net.bluemind.system.api.hot.upgrade.HotUpgradeTask> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.list(filter,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<net.bluemind.system.api.hot.upgrade.HotUpgradeProgress>> progress() {
		
		CompletableFuture<List<net.bluemind.system.api.hot.upgrade.HotUpgradeProgress>> ret = new CompletableFuture<List<net.bluemind.system.api.hot.upgrade.HotUpgradeProgress>>();
		AsyncHandler<List<net.bluemind.system.api.hot.upgrade.HotUpgradeProgress>> handler = new AsyncHandler<List<net.bluemind.system.api.hot.upgrade.HotUpgradeProgress>>() {
			public void success(List<net.bluemind.system.api.hot.upgrade.HotUpgradeProgress> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.progress( handler);
		return ret;
	}


	@Override
	public CompletableFuture<Set<net.bluemind.system.api.hot.upgrade.HotUpgradeTask>> running() {
		
		CompletableFuture<Set<net.bluemind.system.api.hot.upgrade.HotUpgradeTask>> ret = new CompletableFuture<Set<net.bluemind.system.api.hot.upgrade.HotUpgradeTask>>();
		AsyncHandler<Set<net.bluemind.system.api.hot.upgrade.HotUpgradeTask>> handler = new AsyncHandler<Set<net.bluemind.system.api.hot.upgrade.HotUpgradeTask>>() {
			public void success(Set<net.bluemind.system.api.hot.upgrade.HotUpgradeTask> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.running( handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.task.api.TaskRef> start(boolean onlyReady ,  net.bluemind.system.api.hot.upgrade.HotUpgradeTaskExecutionMode mode  ) {
		
		CompletableFuture<net.bluemind.core.task.api.TaskRef> ret = new CompletableFuture<net.bluemind.core.task.api.TaskRef>();
		AsyncHandler<net.bluemind.core.task.api.TaskRef> handler = new AsyncHandler<net.bluemind.core.task.api.TaskRef>() {
			public void success(net.bluemind.core.task.api.TaskRef value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.start(onlyReady, mode,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.task.api.TaskRef> startLimited(long maxDuration ,  net.bluemind.system.api.hot.upgrade.HotUpgradeTaskExecutionMode mode  ) {
		
		CompletableFuture<net.bluemind.core.task.api.TaskRef> ret = new CompletableFuture<net.bluemind.core.task.api.TaskRef>();
		AsyncHandler<net.bluemind.core.task.api.TaskRef> handler = new AsyncHandler<net.bluemind.core.task.api.TaskRef>() {
			public void success(net.bluemind.core.task.api.TaskRef value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.startLimited(maxDuration, mode,  handler);
		return ret;
	}

}
