/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.system.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class DomainTemplateDescriptionI18NDescriptionGwtSerDer implements GwtSerDer<net.bluemind.system.api.DomainTemplate.Description.I18NDescription> {

	public DomainTemplateDescriptionI18NDescriptionGwtSerDer( ) {
	}

	@Override
	public net.bluemind.system.api.DomainTemplate.Description.I18NDescription deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.system.api.DomainTemplate.Description.I18NDescription ret = new net.bluemind.system.api.DomainTemplate.Description.I18NDescription();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.system.api.DomainTemplate.Description.I18NDescription ret, JSONObject json) {
		JSONValue langJSON = json.get("lang");
		ret.lang =  GwtSerDerUtils.STRING.deserialize(langJSON);
		JSONValue textJSON = json.get("text");
		ret.text =  GwtSerDerUtils.STRING.deserialize(textJSON);
		JSONValue helpTextJSON = json.get("helpText");
		ret.helpText =  GwtSerDerUtils.STRING.deserialize(helpTextJSON);
	}

	public void deserializeTo(net.bluemind.system.api.DomainTemplate.Description.I18NDescription ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("lang")) {
			JSONValue langJSON = json.get("lang");
			ret.lang =  GwtSerDerUtils.STRING.deserialize(langJSON);
		}
		if (!childPropertiesToIgnore.contains("text")) {
			JSONValue textJSON = json.get("text");
			ret.text =  GwtSerDerUtils.STRING.deserialize(textJSON);
		}
		if (!childPropertiesToIgnore.contains("helpText")) {
			JSONValue helpTextJSON = json.get("helpText");
			ret.helpText =  GwtSerDerUtils.STRING.deserialize(helpTextJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.system.api.DomainTemplate.Description.I18NDescription o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.system.api.DomainTemplate.Description.I18NDescription o, JSONObject ret) {

		ret.put("lang",  GwtSerDerUtils.STRING.serialize( o.lang ));
		ret.put("text",  GwtSerDerUtils.STRING.serialize( o.text ));
		ret.put("helpText",  GwtSerDerUtils.STRING.serialize( o.helpText ));
	}

	public void serializeTo(net.bluemind.system.api.DomainTemplate.Description.I18NDescription o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("lang")) {
			ret.put("lang",  GwtSerDerUtils.STRING.serialize( o.lang ));
		}
		if (!childPropertiesToIgnore.contains("text")) {
			ret.put("text",  GwtSerDerUtils.STRING.serialize( o.text ));
		}
		if (!childPropertiesToIgnore.contains("helpText")) {
			ret.put("helpText",  GwtSerDerUtils.STRING.serialize( o.helpText ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}