/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.system.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;
import java.util.concurrent.CompletableFuture;

public class InternalCredentialsEndpointPromise implements net.bluemind.system.api.IInternalCredentialsPromise {

	private net.bluemind.system.api.IInternalCredentialsAsync impl;

	public InternalCredentialsEndpointPromise(net.bluemind.system.api.IInternalCredentialsAsync impl) {
		this.impl = impl;
	}

	@Override
	public CompletableFuture<Void> addUserCredential(String userUid ,  net.bluemind.system.api.Credential credential  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.addUserCredential(userUid, credential,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> addUserCredentials(String userUid ,  List<net.bluemind.system.api.Credential> credentials  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.addUserCredentials(userUid, credentials,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<String> getDomainCredentialById(String credentialId  ) {
		
		CompletableFuture<String> ret = new CompletableFuture<String>();
		AsyncHandler<String> handler = new AsyncHandler<String>() {
			public void success(String value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getDomainCredentialById(credentialId,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.api.ListResult<net.bluemind.system.api.Credential>> getObfuscatedUserCredentials(String userUid  ) {
		
		CompletableFuture<net.bluemind.core.api.ListResult<net.bluemind.system.api.Credential>> ret = new CompletableFuture<net.bluemind.core.api.ListResult<net.bluemind.system.api.Credential>>();
		AsyncHandler<net.bluemind.core.api.ListResult<net.bluemind.system.api.Credential>> handler = new AsyncHandler<net.bluemind.core.api.ListResult<net.bluemind.system.api.Credential>>() {
			public void success(net.bluemind.core.api.ListResult<net.bluemind.system.api.Credential> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getObfuscatedUserCredentials(userUid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<net.bluemind.system.api.Credential>> getUserCredentials(String userUid  ) {
		
		CompletableFuture<List<net.bluemind.system.api.Credential>> ret = new CompletableFuture<List<net.bluemind.system.api.Credential>>();
		AsyncHandler<List<net.bluemind.system.api.Credential>> handler = new AsyncHandler<List<net.bluemind.system.api.Credential>>() {
			public void success(List<net.bluemind.system.api.Credential> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getUserCredentials(userUid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> removeUserCredential(String userUid ,  String credentialId  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.removeUserCredential(userUid, credentialId,  handler);
		return ret;
	}

}
